/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.batch.admin.web.util.ResourceInfo;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class AnnotationMappingMetaData
implements ApplicationContextAware,
InitializingBean {
    @Autowired(required=false)
    private DefaultAnnotationHandlerMapping mapping;
    private ApplicationContext applicationContext;
    private Set<String> urls;
    private List<ResourceInfo> resources;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mapping == null) {
            this.mapping = new DefaultAnnotationHandlerMapping();
            this.mapping.setApplicationContext(this.applicationContext);
            this.mapping.initApplicationContext();
        }
        Map handlerMap = this.mapping.getHandlerMap();
        this.urls = this.findUniqueUrls(handlerMap.keySet());
        this.resources = this.findMethods(handlerMap, this.urls);
    }

    private List<ResourceInfo> findMethods(Map<String, Object> handlerMap, Set<String> urls) {
        TreeSet<ResourceInfo> result = new TreeSet<ResourceInfo>();
        for (String key : urls) {
            Object handler = handlerMap.get(key);
            Class handlerType = ClassUtils.getUserClass((Object)handler);
            HandlerMethodResolver resolver = new HandlerMethodResolver();
            resolver.init(handlerType);
            for (Method method : resolver.getHandlerMethods()) {
                RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                RequestMethod[] methods = mapping.method();
                if (methods != null && methods.length > 0) {
                    for (RequestMethod requestMethod : methods) {
                        result.add(new ResourceInfo(key, requestMethod));
                    }
                    continue;
                }
                result.add(new ResourceInfo(key, RequestMethod.GET));
            }
        }
        return new ArrayList<ResourceInfo>(result);
    }

    private Set<String> findUniqueUrls(Collection<String> inputs) {
        HashSet<String> result = new HashSet<String>(inputs);
        for (String url : inputs) {
            String extended = url + ".*";
            if (inputs.contains(extended)) {
                result.remove(extended);
            }
            if (!inputs.contains(extended = url + "/")) continue;
            result.remove(extended);
        }
        return result;
    }

    @RequestMapping(value={"/home"}, method={RequestMethod.GET})
    @ModelAttribute(value="resources")
    public List<ResourceInfo> getResources() {
        return this.resources;
    }

    public Set<String> getUrlPatterns() {
        return this.urls;
    }
}

