/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.database.KeyCollector;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SingleColumnJdbcKeyCollector
extends ExecutionContextUserSupport
implements KeyCollector {
    private static final String RESTART_KEY = "key";
    private JdbcTemplate jdbcTemplate;
    private String sql;
    private String restartSql;
    private RowMapper keyMapper = new SingleColumnRowMapper();

    public SingleColumnJdbcKeyCollector() {
        this.setName(ClassUtils.getShortName((Class)SingleColumnJdbcKeyCollector.class));
    }

    public SingleColumnJdbcKeyCollector(JdbcTemplate jdbcTemplate, String sql) {
        this();
        Assert.notNull((Object)jdbcTemplate, (String)"JdbcTemplate must not be null.");
        Assert.hasText((String)sql, (String)"The sql statement must not be null or empty.");
        this.jdbcTemplate = jdbcTemplate;
        this.sql = sql;
    }

    public List retrieveKeys(ExecutionContext executionContext) {
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null");
        if (executionContext.containsKey(this.getKey(RESTART_KEY))) {
            Assert.state((boolean)StringUtils.hasText((String)this.restartSql), (String)"The restart sql query must not be null or empty in order to restart.");
            return this.jdbcTemplate.query(this.restartSql, new Object[]{executionContext.get(this.getKey(RESTART_KEY))}, this.keyMapper);
        }
        return this.jdbcTemplate.query(this.sql, this.keyMapper);
    }

    public void updateContext(Object key, ExecutionContext executionContext) {
        Assert.notNull((Object)key, (String)"The key must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null");
        executionContext.put(this.getKey(RESTART_KEY), key);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"JdbcTemplate must not be null.");
        Assert.hasText((String)this.sql, (String)"The DrivingQuery must not be null or empty.");
    }

    public void setKeyMapper(RowMapper keyMapper) {
        this.keyMapper = keyMapper;
    }

    public void setRestartSql(String restartSql) {
        this.restartSql = restartSql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

