/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.file.mapping.DefaultFieldSet;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;

public abstract class AbstractLineTokenizer
implements LineTokenizer {
    protected String[] names = new String[0];

    public void setNames(String[] names) {
        this.names = names;
    }

    public boolean hasNames() {
        return this.names != null && this.names.length > 0;
    }

    public FieldSet tokenize(String line) {
        if (line == null || line.length() == 0) {
            return new DefaultFieldSet(new String[0]);
        }
        ArrayList tokens = new ArrayList(this.doTokenize(line));
        for (int i = tokens.size(); i < this.names.length; ++i) {
            tokens.add(null);
        }
        String[] values = tokens.toArray(new String[tokens.size()]);
        if (this.names.length == 0) {
            return new DefaultFieldSet(values);
        }
        return new DefaultFieldSet(values, this.names);
    }

    protected abstract List doTokenize(String var1);
}

