/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.Arrays;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.util.Assert;

public class FixedLengthLineAggregator
implements LineAggregator {
    private static final int ALIGN_CENTER = 1;
    private static final int ALIGN_RIGHT = 2;
    private static final int ALIGN_LEFT = 3;
    private Range[] ranges;
    private int lastColumn;
    private int align = 3;
    private char padding = (char)32;

    public void setColumns(Range[] columns) {
        Assert.notNull((Object)columns);
        this.lastColumn = this.findLastColumn(columns);
        this.ranges = columns;
    }

    public String aggregate(FieldSet fieldSet) {
        Assert.notNull((Object)fieldSet);
        Assert.notNull((Object)this.ranges);
        String[] args = fieldSet.getValues();
        Assert.isTrue((args.length <= this.ranges.length ? 1 : 0) != 0, (String)"Number of arguments must match number of fields in a record");
        int lineLength = this.ranges[this.lastColumn].hasMaxValue() ? this.ranges[this.lastColumn].getMax() : this.ranges[this.lastColumn].getMin() + args[this.lastColumn].length() - 1;
        char[] emptyLine = new char[lineLength];
        Arrays.fill(emptyLine, this.padding);
        StringBuffer stringBuffer = new StringBuffer(lineLength);
        stringBuffer.append(emptyLine);
        for (int i = 0; i < args.length; ++i) {
            int start = this.ranges[i].getMin() - 1;
            int columnLength = i == this.lastColumn && !this.ranges[this.lastColumn].hasMaxValue() ? args[this.lastColumn].length() : this.ranges[i].getMax() - this.ranges[i].getMin() + 1;
            String textToInsert = args[i] == null ? "" : args[i];
            Assert.isTrue((columnLength >= textToInsert.length() ? 1 : 0) != 0, (String)("Supplied text: " + textToInsert + " is longer than defined length: " + columnLength));
            switch (this.align) {
                case 2: {
                    start += columnLength - textToInsert.length();
                    break;
                }
                case 1: {
                    start += (columnLength - textToInsert.length()) / 2;
                    break;
                }
            }
            stringBuffer.replace(start, start + textToInsert.length(), textToInsert);
        }
        return stringBuffer.toString();
    }

    public void setAlignment(String alignment) {
        if ("CENTER".equalsIgnoreCase(alignment)) {
            this.align = 1;
        } else if ("RIGHT".equalsIgnoreCase(alignment)) {
            this.align = 2;
        } else if ("LEFT".equalsIgnoreCase(alignment)) {
            this.align = 3;
        } else {
            throw new IllegalArgumentException("Only 'CENTER', 'RIGHT' or 'LEFT' are allowed alignment values");
        }
    }

    public void setPadding(char padding) {
        this.padding = padding;
    }

    private int findLastColumn(Range[] columns) {
        int lastOffset = 1;
        int lastIndex = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getMin() <= lastOffset) continue;
            lastOffset = columns[i].getMin();
            lastIndex = i;
        }
        return lastIndex;
    }
}

