/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ReaderNotOpenException;
import org.springframework.batch.item.xml.EventReaderDeserializer;
import org.springframework.batch.item.xml.stax.DefaultFragmentEventReader;
import org.springframework.batch.item.xml.stax.DefaultTransactionalEventReader;
import org.springframework.batch.item.xml.stax.FragmentEventReader;
import org.springframework.batch.item.xml.stax.TransactionalEventReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class StaxEventItemReader
extends ExecutionContextUserSupport
implements ItemReader,
ItemStream,
InitializingBean {
    private static final String READ_COUNT_STATISTICS_NAME = "read.count";
    private FragmentEventReader fragmentReader;
    private TransactionalEventReader txReader;
    private EventReaderDeserializer eventReaderDeserializer;
    private Resource resource;
    private InputStream inputStream;
    private String fragmentRootElementName;
    private boolean initialized = false;
    private long lastCommitPointRecordCount = 0L;
    private long currentRecordCount = 0L;
    private boolean saveState = false;

    public StaxEventItemReader() {
        this.setName(ClassUtils.getShortName((Class)StaxEventItemReader.class));
    }

    public Object read() {
        if (!this.initialized) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        Object item = null;
        ++this.currentRecordCount;
        if (this.moveCursorToNextFragment(this.fragmentReader)) {
            this.fragmentReader.markStartFragment();
            item = this.eventReaderDeserializer.deserializeFragment(this.fragmentReader);
            this.fragmentReader.markFragmentProcessed();
        }
        if (item == null) {
            --this.currentRecordCount;
        }
        return item;
    }

    public void close(ExecutionContext executionContext) {
        this.initialized = false;
        this.currentRecordCount = 0L;
        try {
            if (this.fragmentReader != null) {
                this.fragmentReader.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (XMLStreamException e) {
            throw new DataAccessResourceFailureException("Error while closing event reader", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Error while closing input stream", (Throwable)e);
        }
        finally {
            this.fragmentReader = null;
            this.inputStream = null;
        }
    }

    public void open(ExecutionContext executionContext) {
        Assert.state((boolean)this.resource.exists(), (String)("Input resource does not exist: [" + this.resource + "]"));
        try {
            this.inputStream = this.resource.getInputStream();
            this.txReader = new DefaultTransactionalEventReader(XMLInputFactory.newInstance().createXMLEventReader(this.inputStream));
            this.fragmentReader = new DefaultFragmentEventReader(this.txReader);
        }
        catch (XMLStreamException xse) {
            throw new DataAccessResourceFailureException("Unable to create XML reader", (Throwable)xse);
        }
        catch (IOException ioe) {
            throw new DataAccessResourceFailureException("Unable to get input stream", (Throwable)ioe);
        }
        this.initialized = true;
        if (executionContext.containsKey(this.getKey(READ_COUNT_STATISTICS_NAME))) {
            long restoredRecordCount = executionContext.getLong(this.getKey(READ_COUNT_STATISTICS_NAME));
            int REASONABLE_ADHOC_COMMIT_FREQUENCY = 100;
            while (this.currentRecordCount <= restoredRecordCount) {
                ++this.currentRecordCount;
                if (this.currentRecordCount % (long)REASONABLE_ADHOC_COMMIT_FREQUENCY == 0L) {
                    this.txReader.onCommit();
                }
                if (!this.fragmentReader.hasNext()) {
                    throw new ItemStreamException("Restore point must be before end of input");
                }
                this.fragmentReader.next();
                this.moveCursorToNextFragment(this.fragmentReader);
            }
            this.mark();
        }
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setFragmentDeserializer(EventReaderDeserializer eventReaderDeserializer) {
        this.eventReaderDeserializer = eventReaderDeserializer;
    }

    public void setFragmentRootElementName(String fragmentRootElementName) {
        this.fragmentRootElementName = fragmentRootElementName;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"The Resource must not be null.");
        Assert.notNull((Object)this.eventReaderDeserializer, (String)"The FragmentDeserializer must not be null.");
        Assert.hasLength((String)this.fragmentRootElementName, (String)"The FragmentRootElementName must not be null");
    }

    public void update(ExecutionContext executionContext) {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(this.getKey(READ_COUNT_STATISTICS_NAME), this.currentRecordCount);
        }
    }

    protected boolean moveCursorToNextFragment(XMLEventReader reader) {
        try {
            while (true) {
                if (reader.peek() != null && !reader.peek().isStartElement()) {
                    reader.nextEvent();
                    continue;
                }
                if (reader.peek() == null) {
                    return false;
                }
                QName startElementName = ((StartElement)reader.peek()).getName();
                if (startElementName.getLocalPart().equals(this.fragmentRootElementName)) {
                    return true;
                }
                reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new DataAccessResourceFailureException("Error while reading from event reader", (Throwable)e);
        }
    }

    public void mark() {
        this.lastCommitPointRecordCount = this.currentRecordCount;
        this.txReader.onCommit();
    }

    public void reset() {
        this.currentRecordCount = this.lastCommitPointRecordCount;
        this.txReader.onRollback();
        this.fragmentReader.reset();
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }
}

