/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat;

import java.io.Serializable;
import org.springframework.util.StringUtils;

public class ExitStatus
implements Serializable {
    public static final ExitStatus UNKNOWN = new ExitStatus(true, "UNKNOWN");
    public static final ExitStatus CONTINUABLE = new ExitStatus(true, "CONTINUABLE");
    public static final ExitStatus FINISHED = new ExitStatus(false, "COMPLETED");
    public static final ExitStatus NOOP = new ExitStatus(false, "NOOP");
    public static final ExitStatus FAILED = new ExitStatus(false, "FAILED");
    private final boolean continuable;
    private final String exitCode;
    private final String exitDescription;

    public ExitStatus(boolean continuable) {
        this(continuable, "", "");
    }

    public ExitStatus(boolean continuable, String exitCode) {
        this(continuable, exitCode, "");
    }

    public ExitStatus(boolean continuable, String exitCode, String exitDescription) {
        this.continuable = continuable;
        this.exitCode = exitCode;
        this.exitDescription = exitDescription;
    }

    public boolean isContinuable() {
        return this.continuable;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getExitDescription() {
        return this.exitDescription;
    }

    public ExitStatus and(boolean continuable) {
        return new ExitStatus(this.continuable && continuable, this.exitCode, this.exitDescription);
    }

    public ExitStatus and(ExitStatus status) {
        if (status == null) {
            return this;
        }
        ExitStatus result = this.and(status.continuable).addExitDescription(status.exitDescription);
        if (result.continuable || !status.continuable) {
            result = result.replaceExitCode(status.exitCode);
        }
        return result;
    }

    public String toString() {
        return "continuable=" + this.continuable + ";exitCode=" + this.exitCode + ";exitDescription=" + this.exitDescription;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ExitStatus replaceExitCode(String code) {
        return new ExitStatus(this.continuable, code, this.exitDescription);
    }

    public boolean isRunning() {
        return "RUNNING".equals(this.exitCode) || "UNKNOWN".equals(this.exitCode);
    }

    public ExitStatus addExitDescription(String description) {
        if (StringUtils.hasText((String)this.exitDescription) && StringUtils.hasText((String)description) && !this.exitDescription.equals(description)) {
            description = this.exitDescription + "; " + description;
        }
        return new ExitStatus(this.continuable, this.exitCode, description);
    }
}

