/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.DefaultResultCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.util.Assert;

public class RepeatTemplate
implements RepeatOperations {
    protected Log logger = LogFactory.getLog(this.getClass());
    private RepeatListener[] listeners = new RepeatListener[0];
    private CompletionPolicy completionPolicy = new DefaultResultCompletionPolicy();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = listeners;
    }

    public void registerListener(RepeatListener listener) {
        ArrayList<RepeatListener> list = new ArrayList<RepeatListener>(Arrays.asList(this.listeners));
        list.add(listener);
        this.listeners = list.toArray(new RepeatListener[list.size()]);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setCompletionPolicy(CompletionPolicy terminationPolicy) {
        Assert.notNull((Object)terminationPolicy);
        this.completionPolicy = terminationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExitStatus iterate(RepeatCallback callback) {
        RepeatContext outer = RepeatSynchronizationManager.getContext();
        ExitStatus result = ExitStatus.CONTINUABLE;
        try {
            result = this.executeInternal(callback);
        }
        finally {
            RepeatSynchronizationManager.clear();
            if (outer != null) {
                RepeatSynchronizationManager.register(outer);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExitStatus executeInternal(RepeatCallback callback) {
        RepeatListener interceptor;
        int i;
        RepeatContext context = this.start();
        boolean running = !this.isMarkedComplete(context);
        for (int i2 = 0; i2 < this.listeners.length; ++i2) {
            RepeatListener interceptor2 = this.listeners[i2];
            interceptor2.open(context);
            boolean bl = running = running && !this.isMarkedComplete(context);
            if (!running) break;
        }
        ExitStatus result = ExitStatus.CONTINUABLE;
        RepeatInternalState state = this.createInternalState(context);
        Collection throwables = state.getThrowables();
        try {
            while (running) {
                for (i = 0; i < this.listeners.length; ++i) {
                    interceptor = this.listeners[i];
                    interceptor.before(context);
                    running = running && !this.isMarkedComplete(context);
                }
                if (!running) continue;
                this.logger.debug((Object)("Batch operation about to start at count=" + context.getStartedCount()));
                try {
                    result = this.getNextResult(context, callback, state);
                    this.executeAfterInterceptors(context, result);
                }
                catch (Throwable throwable) {
                    Throwable unwrappedThrowable = RepeatTemplate.unwrapIfRethrown(throwable);
                    try {
                        int i3 = this.listeners.length;
                        while (i3-- > 0) {
                            RepeatListener interceptor3 = this.listeners[i3];
                            interceptor3.onError(context, unwrappedThrowable);
                            this.logger.debug((Object)("Exception intercepted (" + (i3 + 1) + " of " + this.listeners.length + ")"), unwrappedThrowable);
                        }
                        this.exceptionHandler.handleException(context, unwrappedThrowable);
                    }
                    catch (Throwable handled) {
                        throwables.add(handled);
                    }
                }
                if (!this.isComplete(context, result) && !this.isMarkedComplete(context) && throwables.isEmpty()) continue;
                running = false;
            }
            result = result.and(this.waitForResults(state));
            state = null;
        }
        finally {
            try {
                if (!throwables.isEmpty()) {
                    RepeatTemplate.rethrow((Throwable)throwables.iterator().next());
                }
            }
            finally {
                try {
                    i = this.listeners.length;
                    while (i-- > 0) {
                        interceptor = this.listeners[i];
                        interceptor.close(context);
                    }
                }
                finally {
                    context.close();
                }
            }
        }
        return result;
    }

    private static void rethrow(Throwable throwable) throws RuntimeException {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RepeatException("Exception in batch process", throwable);
    }

    private static Throwable unwrapIfRethrown(Throwable throwable) {
        if (throwable instanceof RepeatException) {
            return throwable.getCause();
        }
        return throwable;
    }

    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new RepeatInternalStateSupport();
    }

    protected ExitStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        this.update(context);
        return callback.doInIteration(context);
    }

    protected boolean waitForResults(RepeatInternalState state) {
        return true;
    }

    protected final boolean canContinue(ExitStatus value) {
        return value.isContinuable();
    }

    private boolean isMarkedComplete(RepeatContext context) {
        boolean complete = context.isCompleteOnly();
        if (context.getParent() != null) {
            boolean bl = complete = complete || this.isMarkedComplete(context.getParent());
        }
        if (complete) {
            this.logger.debug((Object)"Batch is complete according to context alone.");
        }
        return complete;
    }

    protected void executeAfterInterceptors(RepeatContext context, ExitStatus value) {
        if (value != null && value.isContinuable()) {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.after(context, value);
            }
        }
    }

    protected boolean isComplete(RepeatContext context, ExitStatus result) {
        boolean complete = this.completionPolicy.isComplete(context, result);
        if (complete) {
            this.logger.debug((Object)"Batch is complete according to policy and result value.");
        }
        return complete;
    }

    protected boolean isComplete(RepeatContext context) {
        boolean complete = this.completionPolicy.isComplete(context);
        if (complete) {
            this.logger.debug((Object)"Batch is complete according to policy alone not including result.");
        }
        return complete;
    }

    protected RepeatContext start() {
        RepeatContext parent = RepeatSynchronizationManager.getContext();
        RepeatContext context = this.completionPolicy.start(parent);
        RepeatSynchronizationManager.register(context);
        this.logger.debug((Object)"Starting batch step.");
        return context;
    }

    protected void update(RepeatContext context) {
        this.completionPolicy.update(context);
    }
}

