/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.backoff.NoBackOffPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.batch.retry.support.RetrySynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryTemplate
implements RetryOperations {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile BackOffPolicy backOffPolicy = new NoBackOffPolicy();
    private volatile RetryPolicy retryPolicy = new SimpleRetryPolicy();
    private volatile RetryListener[] listeners = new RetryListener[0];
    private RetryContextCache retryContextCache = new MapRetryContextCache();

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setListeners(RetryListener[] listeners) {
        this.listeners = listeners;
    }

    public void registerListener(RetryListener listener) {
        ArrayList<RetryListener> list = new ArrayList<RetryListener>((Collection)Arrays.asList(this.listeners));
        list.add(listener);
        this.listeners = list.toArray(new RetryListener[list.size()]);
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback) throws Exception {
        return this.doExecute(retryCallback, null, null);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback) throws Exception {
        return this.doExecute(retryCallback, recoveryCallback, null);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return this.doExecute(retryCallback, null, retryState);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return this.doExecute(retryCallback, recoveryCallback, retryState);
    }

    /*
     * Exception decompiling
     */
    protected <T> T doExecute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, RetryState state) throws Exception, ExhaustedRetryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean canRetry(RetryPolicy retryPolicy, RetryContext context) {
        return retryPolicy.canRetry(context);
    }

    protected void close(RetryPolicy retryPolicy, RetryContext context, RetryState state, boolean succeeded) {
        if (state != null) {
            if (succeeded) {
                this.retryContextCache.remove(state.getKey());
                retryPolicy.close(context);
            }
        } else {
            retryPolicy.close(context);
        }
    }

    protected void registerThrowable(RetryPolicy retryPolicy, RetryState state, RetryContext context, Exception e) {
        if (state != null) {
            Object key = state.getKey();
            if (context.getRetryCount() > 0 && !this.retryContextCache.containsKey(key)) {
                throw new RetryException("Inconsistent state for failed item key: cache key has changed. Consider whether equals() or hashCode() for the key might be inconsistent, or if you need to supply a better key");
            }
            this.retryContextCache.put(key, context);
        }
        retryPolicy.registerThrowable(context, e);
    }

    protected RetryContext open(RetryPolicy retryPolicy, RetryState state) {
        if (state == null) {
            return this.doOpenInternal(retryPolicy);
        }
        Object key = state.getKey();
        if (state.isForceRefresh()) {
            return this.doOpenInternal(retryPolicy);
        }
        if (!this.retryContextCache.containsKey(key)) {
            return this.doOpenInternal(retryPolicy);
        }
        RetryContext context = this.retryContextCache.get(key);
        if (context == null) {
            if (this.retryContextCache.containsKey(key)) {
                throw new RetryException("Inconsistent state for failed item: no history found. Consider whether equals() or hashCode() for the item might be inconsistent, or if you need to supply a better ItemKeyGenerator");
            }
            return this.doOpenInternal(retryPolicy);
        }
        return context;
    }

    private RetryContext doOpenInternal(RetryPolicy retryPolicy) {
        return retryPolicy.open(RetrySynchronizationManager.getContext());
    }

    protected <T> T handleRetryExhausted(RecoveryCallback<T> recoveryCallback, RetryContext context, RetryState state) throws Exception {
        if (state != null) {
            this.retryContextCache.remove(state.getKey());
        }
        if (recoveryCallback != null) {
            return recoveryCallback.recover(context);
        }
        if (state != null) {
            this.logger.debug((Object)"Retry exhausted after last attempt with no recovery path.");
            throw new ExhaustedRetryException("Retry exhausted after last attempt with no recovery path", context.getLastThrowable());
        }
        throw context.getLastThrowable();
    }

    protected boolean shouldRethrow(RetryPolicy retryPolicy, RetryContext context, RetryState state) {
        if (state == null) {
            return false;
        }
        return state.rollbackFor(context.getLastThrowable());
    }

    private <T> boolean doOpenInterceptors(RetryCallback<T> callback, RetryContext context) {
        boolean result = true;
        int i = 0;
        while (i < this.listeners.length) {
            result = result && this.listeners[i].open(context, callback);
            ++i;
        }
        return result;
    }

    private <T> void doCloseInterceptors(RetryCallback<T> callback, RetryContext context, Throwable lastException) {
        int i = this.listeners.length;
        while (i-- > 0) {
            this.listeners[i].close(context, callback, lastException);
        }
    }

    private <T> void doOnErrorInterceptors(RetryCallback<T> callback, RetryContext context, Throwable throwable) {
        int i = this.listeners.length;
        while (i-- > 0) {
            this.listeners[i].onError(context, callback, throwable);
        }
    }
}

