/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.Map;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.database.HibernateItemReaderHelper;
import org.springframework.batch.item.database.orm.HibernateQueryProvider;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ItemStream,
InitializingBean {
    private HibernateItemReaderHelper<T> helper = new HibernateItemReaderHelper();
    private ScrollableResults cursor;
    private boolean initialized = false;
    private int fetchSize;
    private Map<String, Object> parameterValues;

    public HibernateCursorItemReader() {
        this.setName(ClassUtils.getShortName(HibernateCursorItemReader.class));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.fetchSize >= 0 ? 1 : 0) != 0, (String)"fetchSize must not be negative");
        this.helper.afterPropertiesSet();
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setQueryName(String queryName) {
        this.helper.setQueryName(queryName);
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryProvider(HibernateQueryProvider queryProvider) {
        this.helper.setQueryProvider(queryProvider);
    }

    public void setQueryString(String queryString) {
        this.helper.setQueryString(queryString);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.helper.setSessionFactory(sessionFactory);
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        this.helper.setUseStatelessSession(useStatelessSession);
    }

    @Override
    protected T doRead() throws Exception {
        if (this.cursor.next()) {
            Object[] data = this.cursor.get();
            if (data.length > 1) {
                Object[] item = data;
                return (T)item;
            }
            Object item = data[0];
            return (T)item;
        }
        return null;
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened ItemReader, call close first");
        this.cursor = this.helper.getForwardOnlyCursor(this.fetchSize, this.parameterValues);
        this.initialized = true;
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.helper.clear();
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        int flushSize = Math.max(this.fetchSize, 100);
        this.helper.jumpToItem(this.cursor, itemIndex, flushSize);
    }

    @Override
    protected void doClose() throws Exception {
        this.initialized = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.helper.close();
    }
}

