/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWrapperFieldExtractor<T>
implements FieldExtractor<T>,
InitializingBean {
    private String[] names;

    public void setNames(String[] names) {
        Assert.notNull((Object)names, (String)"Names must be non-null");
        this.names = Arrays.asList(names).toArray(new String[names.length]);
    }

    @Override
    public Object[] extract(T item) {
        ArrayList<Object> values = new ArrayList<Object>();
        BeanWrapperImpl bw = new BeanWrapperImpl(item);
        for (String propertyName : this.names) {
            values.add(bw.getPropertyValue(propertyName));
        }
        return values.toArray();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.names, (String)"The 'names' property must be set.");
    }
}

