/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.batch.item.xml.stax.DefaultFragmentEventReader;
import org.springframework.batch.item.xml.stax.FragmentEventReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.xml.transform.StaxSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxEventItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(StaxEventItemReader.class);
    private FragmentEventReader fragmentReader;
    private XMLEventReader eventReader;
    private Unmarshaller unmarshaller;
    private Resource resource;
    private InputStream inputStream;
    private String fragmentRootElementName;
    private boolean noInput;
    private boolean strict = true;
    private String fragmentRootElementNameSpace;

    public StaxEventItemReader() {
        this.setName(ClassUtils.getShortName(StaxEventItemReader.class));
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setFragmentRootElementName(String fragmentRootElementName) {
        this.fragmentRootElementName = fragmentRootElementName;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.unmarshaller, (String)"The Unmarshaller must not be null.");
        Assert.hasLength((String)this.fragmentRootElementName, (String)"The FragmentRootElementName must not be null");
        if (this.fragmentRootElementName.contains("{")) {
            this.fragmentRootElementNameSpace = this.fragmentRootElementName.replaceAll("\\{(.*)\\}.*", "$1");
            this.fragmentRootElementName = this.fragmentRootElementName.replaceAll("\\{.*\\}(.*)", "$1");
        }
    }

    protected boolean moveCursorToNextFragment(XMLEventReader reader) throws NonTransientResourceException {
        try {
            while (true) {
                if (reader.peek() != null && !reader.peek().isStartElement()) {
                    reader.nextEvent();
                    continue;
                }
                if (reader.peek() == null) {
                    return false;
                }
                QName startElementName = ((StartElement)reader.peek()).getName();
                if (startElementName.getLocalPart().equals(this.fragmentRootElementName) && (this.fragmentRootElementNameSpace == null || startElementName.getNamespaceURI().equals(this.fragmentRootElementNameSpace))) {
                    return true;
                }
                reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new NonTransientResourceException("Error while reading from event reader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        try {
            if (this.fragmentReader != null) {
                this.fragmentReader.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            Object var2_1 = null;
            this.fragmentReader = null;
            this.inputStream = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.fragmentReader = null;
            this.inputStream = null;
            throw throwable;
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"The Resource must not be null.");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode)");
            }
            logger.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode)");
            }
            logger.warn((Object)("Input resource is not readable " + this.resource.getDescription()));
            return;
        }
        this.inputStream = this.resource.getInputStream();
        this.eventReader = XMLInputFactory.newInstance().createXMLEventReader(this.inputStream);
        this.fragmentReader = new DefaultFragmentEventReader(this.eventReader);
        this.noInput = false;
    }

    @Override
    protected T doRead() throws Exception {
        if (this.noInput) {
            return null;
        }
        Object item = null;
        boolean success = false;
        try {
            success = this.moveCursorToNextFragment(this.fragmentReader);
        }
        catch (NonTransientResourceException e) {
            this.noInput = true;
            throw e;
        }
        if (success) {
            Object mappedFragment;
            this.fragmentReader.markStartFragment();
            item = mappedFragment = this.unmarshaller.unmarshal((Source)new StaxSource((XMLEventReader)this.fragmentReader));
            this.fragmentReader.markFragmentProcessed();
        }
        return (T)item;
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            this.readToStartFragment();
            this.readToEndFragment();
        }
    }

    private void readToStartFragment() throws XMLStreamException {
        XMLEvent nextEvent;
        while (!(nextEvent = this.eventReader.nextEvent()).isStartElement() || !((StartElement)nextEvent).getName().getLocalPart().equals(this.fragmentRootElementName)) {
        }
    }

    private void readToEndFragment() throws XMLStreamException {
        XMLEvent nextEvent;
        while (!(nextEvent = this.eventReader.nextEvent()).isEndElement() || !((EndElement)nextEvent).getName().getLocalPart().equals(this.fragmentRootElementName)) {
        }
    }
}

