/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.exception.RethrowOnThresholdExceptionHandler;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLimitExceptionHandler
implements ExceptionHandler,
InitializingBean {
    private RethrowOnThresholdExceptionHandler delegate = new RethrowOnThresholdExceptionHandler();
    private Collection<Class<? extends Throwable>> exceptionClasses = Collections.singleton(Exception.class);
    private Collection<Class<? extends Throwable>> fatalExceptionClasses = Collections.singleton(Error.class);
    private int limit = 0;

    public void afterPropertiesSet() throws Exception {
        if (this.limit <= 0) {
            return;
        }
        HashMap<Class<? extends Throwable>, Integer> thresholds = new HashMap<Class<? extends Throwable>, Integer>();
        for (Class<? extends Throwable> type : this.exceptionClasses) {
            thresholds.put(type, this.limit);
        }
        for (Class<? extends Throwable> type : this.fatalExceptionClasses) {
            thresholds.put(type, 0);
        }
        this.delegate.setThresholds(thresholds);
    }

    public void setUseParent(boolean useParent) {
        this.delegate.setUseParent(useParent);
    }

    public SimpleLimitExceptionHandler(int limit) {
        this();
        this.limit = limit;
    }

    public SimpleLimitExceptionHandler() {
    }

    @Override
    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        this.delegate.handleException(context, throwable);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setExceptionClasses(Collection<Class<? extends Throwable>> classes) {
        this.exceptionClasses = classes;
    }

    public void setFatalExceptionClasses(Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }
}

