/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.backoff;

import org.springframework.batch.retry.backoff.BackOffInterruptedException;
import org.springframework.batch.retry.backoff.ObjectWaitSleeper;
import org.springframework.batch.retry.backoff.Sleeper;
import org.springframework.batch.retry.backoff.StatelessBackOffPolicy;

public class FixedBackOffPolicy
extends StatelessBackOffPolicy {
    private static final long DEFAULT_BACK_OFF_PERIOD = 1000L;
    private volatile long backOffPeriod = 1000L;
    private Sleeper sleeper = new ObjectWaitSleeper();

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public void setBackOffPeriod(long backOffPeriod) {
        this.backOffPeriod = backOffPeriod > 0L ? backOffPeriod : 1L;
    }

    public long getBackOffPeriod() {
        return this.backOffPeriod;
    }

    protected void doBackOff() throws BackOffInterruptedException {
        try {
            this.sleeper.sleep(this.backOffPeriod);
        }
        catch (InterruptedException e) {
            throw new BackOffInterruptedException("Thread interrupted while sleeping", e);
        }
    }
}

