/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.builder;

import java.beans.PropertyEditor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineCallbackHandler;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.batch.item.file.transform.DefaultFieldSetFactory;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FieldSetFactory;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FlatFileItemReaderBuilder<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean strict = true;
    private RecordSeparatorPolicy recordSeparatorPolicy = new SimpleRecordSeparatorPolicy();
    private Resource resource;
    private List<String> comments = new ArrayList<String>();
    private int linesToSkip = 0;
    private LineCallbackHandler skippedLinesCallback;
    private LineMapper<T> lineMapper;
    private FieldSetMapper<T> fieldSetMapper;
    private LineTokenizer lineTokenizer;
    private DelimitedBuilder<T> delimitedBuilder;
    private FixedLengthBuilder<T> fixedLengthBuilder;
    private Class<? extends T> targetType;
    private String prototypeBeanName;
    private BeanFactory beanFactory;
    private Map<Class<?>, PropertyEditor> customEditors = new HashMap();
    private int distanceLimit = 5;
    private boolean beanMapperStrict = true;
    private BigInteger tokenizerValidator = new BigInteger("0");
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public FlatFileItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public FlatFileItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public FlatFileItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public FlatFileItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public FlatFileItemReaderBuilder<T> addComment(String comment) {
        this.comments.add(comment);
        return this;
    }

    public FlatFileItemReaderBuilder<T> comments(String[] comments) {
        this.comments.addAll(Arrays.asList(comments));
        return this;
    }

    public FlatFileItemReaderBuilder<T> recordSeparatorPolicy(RecordSeparatorPolicy policy) {
        this.recordSeparatorPolicy = policy;
        return this;
    }

    public FlatFileItemReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public FlatFileItemReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public FlatFileItemReaderBuilder<T> linesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
        return this;
    }

    public FlatFileItemReaderBuilder<T> skippedLinesCallback(LineCallbackHandler callback) {
        this.skippedLinesCallback = callback;
        return this;
    }

    public FlatFileItemReaderBuilder<T> lineMapper(LineMapper<T> lineMapper) {
        this.lineMapper = lineMapper;
        return this;
    }

    public FlatFileItemReaderBuilder<T> fieldSetMapper(FieldSetMapper<T> mapper) {
        this.fieldSetMapper = mapper;
        return this;
    }

    public FlatFileItemReaderBuilder<T> lineTokenizer(LineTokenizer tokenizer) {
        this.updateTokenizerValidation(tokenizer, 0);
        this.lineTokenizer = tokenizer;
        return this;
    }

    public DelimitedBuilder<T> delimited() {
        this.delimitedBuilder = new DelimitedBuilder(this);
        this.updateTokenizerValidation(this.delimitedBuilder, 1);
        return this.delimitedBuilder;
    }

    public FixedLengthBuilder<T> fixedLength() {
        this.fixedLengthBuilder = new FixedLengthBuilder(this);
        this.updateTokenizerValidation(this.fixedLengthBuilder, 2);
        return this.fixedLengthBuilder;
    }

    public FlatFileItemReaderBuilder<T> targetType(Class<? extends T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public FlatFileItemReaderBuilder<T> prototypeBeanName(String prototypeBeanName) {
        this.prototypeBeanName = prototypeBeanName;
        return this;
    }

    public FlatFileItemReaderBuilder<T> beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public FlatFileItemReaderBuilder<T> customEditors(Map<Class<?>, PropertyEditor> customEditors) {
        if (customEditors != null) {
            this.customEditors.putAll(customEditors);
        }
        return this;
    }

    public FlatFileItemReaderBuilder<T> distanceLimit(int distanceLimit) {
        this.distanceLimit = distanceLimit;
        return this;
    }

    public FlatFileItemReaderBuilder<T> beanMapperStrict(boolean beanMapperStrict) {
        this.beanMapperStrict = beanMapperStrict;
        return this;
    }

    public FlatFileItemReader<T> build() throws Exception {
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        if (this.resource == null) {
            this.logger.debug((Object)"The resource is null.  This is only a valid scenario when injecting it later as in when using the MultiResourceItemReader");
        }
        Assert.notNull((Object)this.recordSeparatorPolicy, (String)"A RecordSeparatorPolicy is required.");
        int validatorValue = this.tokenizerValidator.intValue();
        FlatFileItemReader reader = new FlatFileItemReader();
        if (StringUtils.hasText((String)this.name)) {
            reader.setName(this.name);
        }
        reader.setResource(this.resource);
        if (this.lineMapper != null) {
            reader.setLineMapper(this.lineMapper);
        } else {
            Assert.state((validatorValue == 1 || validatorValue == 2 || validatorValue == 4 ? 1 : 0) != 0, (String)"Only one LineTokenizer option may be configured");
            DefaultLineMapper<T> lineMapper = new DefaultLineMapper<T>();
            if (this.lineTokenizer != null && this.fieldSetMapper != null) {
                lineMapper.setLineTokenizer(this.lineTokenizer);
            } else if (this.fixedLengthBuilder != null) {
                lineMapper.setLineTokenizer(this.fixedLengthBuilder.build());
            } else if (this.delimitedBuilder != null) {
                lineMapper.setLineTokenizer(this.delimitedBuilder.build());
            } else {
                throw new IllegalStateException("No LineTokenizer implementation was provided.");
            }
            if (this.targetType != null || StringUtils.hasText((String)this.prototypeBeanName)) {
                BeanWrapperFieldSetMapper<? extends T> mapper = new BeanWrapperFieldSetMapper<T>();
                mapper.setTargetType(this.targetType);
                mapper.setPrototypeBeanName(this.prototypeBeanName);
                mapper.setStrict(this.beanMapperStrict);
                mapper.setBeanFactory(this.beanFactory);
                mapper.setDistanceLimit(this.distanceLimit);
                mapper.setCustomEditors(this.customEditors);
                mapper.afterPropertiesSet();
                lineMapper.setFieldSetMapper(mapper);
            } else if (this.fieldSetMapper != null) {
                lineMapper.setFieldSetMapper(this.fieldSetMapper);
            } else {
                throw new IllegalStateException("No FieldSetMapper implementation was provided.");
            }
            reader.setLineMapper(lineMapper);
        }
        reader.setLinesToSkip(this.linesToSkip);
        if (!this.comments.isEmpty()) {
            reader.setComments(this.comments.toArray(new String[this.comments.size()]));
        }
        reader.setSkippedLinesCallback(this.skippedLinesCallback);
        reader.setRecordSeparatorPolicy(this.recordSeparatorPolicy);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setSaveState(this.saveState);
        reader.setStrict(this.strict);
        return reader;
    }

    private void updateTokenizerValidation(Object tokenizer, int index) {
        this.tokenizerValidator = tokenizer != null ? this.tokenizerValidator.flipBit(index) : this.tokenizerValidator.clearBit(index);
    }

    public static class FixedLengthBuilder<T> {
        private FlatFileItemReaderBuilder<T> parent;
        private List<Range> ranges = new ArrayList<Range>();
        private List<String> names = new ArrayList<String>();
        private boolean strict = true;
        private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();

        protected FixedLengthBuilder(FlatFileItemReaderBuilder<T> parent) {
            this.parent = parent;
        }

        public FixedLengthBuilder<T> columns(Range[] ranges) {
            this.ranges.addAll(Arrays.asList(ranges));
            return this;
        }

        public FixedLengthBuilder<T> addColumns(Range range) {
            this.ranges.add(range);
            return this;
        }

        public FixedLengthBuilder<T> addColumns(Range range, int index) {
            this.ranges.add(index, range);
            return this;
        }

        public FlatFileItemReaderBuilder<T> names(String[] names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public FixedLengthBuilder<T> strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public FixedLengthBuilder<T> fieldSetFactory(FieldSetFactory fieldSetFactory) {
            this.fieldSetFactory = fieldSetFactory;
            return this;
        }

        public FixedLengthTokenizer build() {
            Assert.notNull((Object)this.fieldSetFactory, (String)"A FieldSetFactory is required.");
            Assert.notEmpty(this.names, (String)"A list of field names is required.");
            Assert.notEmpty(this.ranges, (String)"A list of column ranges is required.");
            FixedLengthTokenizer tokenizer = new FixedLengthTokenizer();
            tokenizer.setNames(this.names.toArray(new String[this.names.size()]));
            tokenizer.setColumns(this.ranges.toArray(new Range[this.ranges.size()]));
            tokenizer.setFieldSetFactory(this.fieldSetFactory);
            tokenizer.setStrict(this.strict);
            return tokenizer;
        }
    }

    public static class DelimitedBuilder<T> {
        private FlatFileItemReaderBuilder<T> parent;
        private List<String> names = new ArrayList<String>();
        private String delimiter;
        private Character quoteCharacter;
        private List<Integer> includedFields = new ArrayList<Integer>();
        private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();
        private boolean strict = true;

        protected DelimitedBuilder(FlatFileItemReaderBuilder<T> parent) {
            this.parent = parent;
        }

        public DelimitedBuilder<T> delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public DelimitedBuilder<T> quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = Character.valueOf(quoteCharacter);
            return this;
        }

        public DelimitedBuilder<T> includedFields(Integer[] fields) {
            this.includedFields.addAll(Arrays.asList(fields));
            return this;
        }

        public DelimitedBuilder<T> addIncludedField(int field) {
            this.includedFields.add(field);
            return this;
        }

        public DelimitedBuilder<T> fieldSetFactory(FieldSetFactory fieldSetFactory) {
            this.fieldSetFactory = fieldSetFactory;
            return this;
        }

        public FlatFileItemReaderBuilder<T> names(String[] names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public DelimitedLineTokenizer build() throws Exception {
            Assert.notNull((Object)this.fieldSetFactory, (String)"A FieldSetFactory is required.");
            Assert.notEmpty(this.names, (String)"A list of field names is required");
            DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer();
            tokenizer.setNames(this.names.toArray(new String[this.names.size()]));
            if (StringUtils.hasText((String)this.delimiter)) {
                tokenizer.setDelimiter(this.delimiter);
            }
            if (this.quoteCharacter != null) {
                tokenizer.setQuoteCharacter(this.quoteCharacter.charValue());
            }
            if (!this.includedFields.isEmpty()) {
                HashSet<Integer> deDupedFields = new HashSet<Integer>(this.includedFields.size());
                deDupedFields.addAll(this.includedFields);
                deDupedFields.remove(null);
                int[] fields = new int[deDupedFields.size()];
                Iterator iterator = deDupedFields.iterator();
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = (Integer)iterator.next();
                }
                tokenizer.setIncludedFields(fields);
            }
            tokenizer.setFieldSetFactory(this.fieldSetFactory);
            tokenizer.setStrict(this.strict);
            tokenizer.afterPropertiesSet();
            return tokenizer;
        }
    }
}

