/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.avro;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class AvroItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T> {
    private boolean embeddedSchema = true;
    private InputStreamReader<T> inputStreamReader;
    private DataFileStream<T> dataFileReader;
    private InputStream inputStream;
    private DatumReader<T> datumReader;

    public AvroItemReader(Resource resource, Class<T> clazz) {
        Assert.notNull((Object)resource, (String)"'resource' is required.");
        Assert.notNull(clazz, (String)"'class' is required.");
        try {
            this.inputStream = resource.getInputStream();
            this.datumReader = AvroItemReader.datumReaderForClass(clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public AvroItemReader(Resource data, Resource schema) {
        Assert.notNull((Object)data, (String)"'data' is required.");
        Assert.state((boolean)data.exists(), (String)("'data' " + data.getFilename() + " does not exist."));
        Assert.notNull((Object)schema, (String)"'schema' is required");
        Assert.state((boolean)schema.exists(), (String)("'schema' " + schema.getFilename() + " does not exist."));
        try {
            this.inputStream = data.getInputStream();
            Schema avroSchema = new Schema.Parser().parse(schema.getInputStream());
            this.datumReader = new GenericDatumReader(avroSchema);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void setEmbeddedSchema(boolean embeddedSchema) {
        this.embeddedSchema = embeddedSchema;
    }

    @Override
    protected T doRead() throws Exception {
        if (this.inputStreamReader != null) {
            return (T)((InputStreamReader)this.inputStreamReader).read();
        }
        return (T)(this.dataFileReader.hasNext() ? this.dataFileReader.next() : null);
    }

    @Override
    protected void doOpen() throws Exception {
        this.initializeReader();
    }

    @Override
    protected void doClose() throws Exception {
        if (this.inputStreamReader != null) {
            ((InputStreamReader)this.inputStreamReader).close();
            return;
        }
        this.dataFileReader.close();
    }

    private void initializeReader() throws IOException {
        if (this.embeddedSchema) {
            this.dataFileReader = new DataFileStream(this.inputStream, this.datumReader);
        } else {
            this.inputStreamReader = this.createInputStreamReader(this.inputStream, this.datumReader);
        }
    }

    private InputStreamReader<T> createInputStreamReader(InputStream inputStream, DatumReader<T> datumReader) {
        return new InputStreamReader(inputStream, datumReader);
    }

    private static <T> DatumReader<T> datumReaderForClass(Class<T> clazz) {
        if (SpecificRecordBase.class.isAssignableFrom(clazz)) {
            return new SpecificDatumReader(clazz);
        }
        if (GenericRecord.class.isAssignableFrom(clazz)) {
            return new GenericDatumReader();
        }
        return new ReflectDatumReader(clazz);
    }

    private static class InputStreamReader<T> {
        private final DatumReader<T> datumReader;
        private final BinaryDecoder binaryDecoder;
        private final InputStream inputStream;

        private InputStreamReader(InputStream inputStream, DatumReader<T> datumReader) {
            this.inputStream = inputStream;
            this.datumReader = datumReader;
            this.binaryDecoder = DecoderFactory.get().binaryDecoder(inputStream, null);
        }

        private T read() throws Exception {
            if (!this.binaryDecoder.isEnd()) {
                return (T)this.datumReader.read(null, (Decoder)this.binaryDecoder);
            }
            return null;
        }

        private void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new ItemStreamException(e.getMessage(), e);
            }
        }
    }
}

