/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import java.util.Map;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.PatternMatchingCompositeLineTokenizer;
import org.springframework.batch.support.PatternMatcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class PatternMatchingCompositeLineMapper<T>
implements LineMapper<T>,
InitializingBean {
    private PatternMatchingCompositeLineTokenizer tokenizer = new PatternMatchingCompositeLineTokenizer();
    private PatternMatcher<FieldSetMapper<T>> patternMatcher;

    @Override
    public T mapLine(String line, int lineNumber) throws Exception {
        return this.patternMatcher.match(line).mapFieldSet(this.tokenizer.tokenize(line));
    }

    public void afterPropertiesSet() throws Exception {
        this.tokenizer.afterPropertiesSet();
        Assert.state((this.patternMatcher != null ? 1 : 0) != 0, (String)"The 'patternMatcher' property must be non-null");
    }

    public void setTokenizers(Map<String, LineTokenizer> tokenizers) {
        this.tokenizer.setTokenizers(tokenizers);
    }

    public void setFieldSetMappers(Map<String, FieldSetMapper<T>> fieldSetMappers) {
        Assert.isTrue((!fieldSetMappers.isEmpty() ? 1 : 0) != 0, (String)"The 'fieldSetMappers' property must be non-empty");
        this.patternMatcher = new PatternMatcher<FieldSetMapper<T>>(fieldSetMappers);
    }
}

