/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.database.AbstractPagingItemReader;
import org.springframework.batch.infrastructure.item.database.Order;
import org.springframework.batch.infrastructure.item.database.PagingQueryProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;

public class JdbcPagingItemReader<T>
extends AbstractPagingItemReader<T>
implements InitializingBean {
    private static final String START_AFTER_VALUE = "start.after";
    public static final int VALUE_NOT_SET = -1;
    private DataSource dataSource;
    private PagingQueryProvider queryProvider;
    private @Nullable Map<String, Object> parameterValues;
    private @Nullable NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private @Nullable RowMapper<T> rowMapper;
    private @Nullable String firstPageSql;
    private @Nullable String remainingPagesSql;
    private @Nullable Map<String, Object> startAfterValues;
    private @Nullable Map<String, Object> previousStartAfterValues;
    private int fetchSize = -1;

    public JdbcPagingItemReader(DataSource dataSource, PagingQueryProvider pagingQueryProvider) {
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        Assert.notNull((Object)pagingQueryProvider, (String)"PagingQueryProvider must not be null");
        this.dataSource = dataSource;
        this.queryProvider = pagingQueryProvider;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryProvider(PagingQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        if (this.fetchSize != -1) {
            jdbcTemplate.setFetchSize(this.fetchSize);
        }
        jdbcTemplate.setMaxRows(this.getPageSize());
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.queryProvider.init(this.dataSource);
        this.firstPageSql = this.queryProvider.generateFirstPageQuery(this.getPageSize());
        this.remainingPagesSql = this.queryProvider.generateRemainingPagesQuery(this.getPageSize());
    }

    @Override
    protected void doReadPage() {
        List query;
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        PagingRowMapper rowCallback = new PagingRowMapper();
        if (this.getPage() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL used for reading first page: [" + this.firstPageSql + "]"));
            }
            query = this.parameterValues != null && !this.parameterValues.isEmpty() ? (this.queryProvider.isUsingNamedParameters() ? this.namedParameterJdbcTemplate.query(this.firstPageSql, this.getParameterMap(this.parameterValues, null), (RowMapper)rowCallback) : this.getJdbcTemplate().query(this.firstPageSql, (RowMapper)rowCallback, this.getParameterList(this.parameterValues, null).toArray())) : this.getJdbcTemplate().query(this.firstPageSql, (RowMapper)rowCallback);
        } else if (this.startAfterValues != null) {
            this.previousStartAfterValues = this.startAfterValues;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL used for reading remaining pages: [" + this.remainingPagesSql + "]"));
            }
            query = this.queryProvider.isUsingNamedParameters() ? this.namedParameterJdbcTemplate.query(this.remainingPagesSql, this.getParameterMap(this.parameterValues, this.startAfterValues), (RowMapper)rowCallback) : this.getJdbcTemplate().query(this.remainingPagesSql, (RowMapper)rowCallback, this.getParameterList(this.parameterValues, this.startAfterValues).toArray());
        } else {
            query = Collections.emptyList();
        }
        this.results.addAll(query);
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        if (this.isSaveState()) {
            if (this.isAtEndOfPage() && this.startAfterValues != null) {
                executionContext.put(this.getExecutionContextKey(START_AFTER_VALUE), this.startAfterValues);
            } else if (this.previousStartAfterValues != null) {
                executionContext.put(this.getExecutionContextKey(START_AFTER_VALUE), this.previousStartAfterValues);
            }
        }
    }

    private boolean isAtEndOfPage() {
        return this.getCurrentItemCount() % this.getPageSize() == 0;
    }

    @Override
    public void open(ExecutionContext executionContext) {
        if (this.isSaveState()) {
            this.startAfterValues = (Map)executionContext.get(this.getExecutionContextKey(START_AFTER_VALUE));
            if (this.startAfterValues == null) {
                this.startAfterValues = new LinkedHashMap<String, Object>();
            }
        }
        super.open(executionContext);
    }

    private Map<String, Object> getParameterMap(@Nullable Map<String, Object> values, @Nullable Map<String, Object> sortKeyValues) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        if (values != null) {
            parameterMap.putAll(values);
        }
        if (sortKeyValues != null && !sortKeyValues.isEmpty()) {
            for (Map.Entry<String, Object> sortKey : sortKeyValues.entrySet()) {
                parameterMap.put("_" + sortKey.getKey(), sortKey.getValue());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using parameterMap:" + String.valueOf(parameterMap)));
        }
        return parameterMap;
    }

    private List<Object> getParameterList(@Nullable Map<String, Object> values, @Nullable Map<String, Object> sortKeyValue) {
        TreeMap<String, Object> sm = new TreeMap<String, Object>();
        if (values != null) {
            sm.putAll(values);
        }
        ArrayList<Object> parameterList = new ArrayList<Object>(sm.values());
        if (sortKeyValue != null && !sortKeyValue.isEmpty()) {
            ArrayList<Map.Entry<String, Object>> keys = new ArrayList<Map.Entry<String, Object>>(sortKeyValue.entrySet());
            for (int i = 0; i < keys.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    parameterList.add(((Map.Entry)keys.get(j)).getValue());
                }
                parameterList.add(((Map.Entry)keys.get(i)).getValue());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using parameterList:" + String.valueOf(parameterList)));
        }
        return parameterList;
    }

    private JdbcTemplate getJdbcTemplate() {
        return (JdbcTemplate)this.namedParameterJdbcTemplate.getJdbcOperations();
    }

    private class PagingRowMapper
    implements RowMapper<T> {
        private PagingRowMapper() {
        }

        public @Nullable T mapRow(ResultSet rs, int rowNum) throws SQLException {
            JdbcPagingItemReader.this.startAfterValues = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Order> sortKey : JdbcPagingItemReader.this.queryProvider.getSortKeys().entrySet()) {
                JdbcPagingItemReader.this.startAfterValues.put(sortKey.getKey(), rs.getObject(sortKey.getKey()));
            }
            return JdbcPagingItemReader.this.rowMapper.mapRow(rs, rowNum);
        }
    }
}

