/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.lang.reflect.Method;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.item.adapter.HippyMethodInvoker;
import org.springframework.batch.test.MetaDataInstanceFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class StepScopeTestExecutionListener
implements TestExecutionListener {
    private static final String STEP_EXECUTION = StepScopeTestExecutionListener.class.getName() + ".STEP_EXECUTION";
    private static final String SET_ATTRIBUTE_METHOD_NAME = "setAttribute";
    private static final String HAS_ATTRIBUTE_METHOD_NAME = "hasAttribute";
    private static final String GET_ATTRIBUTE_METHOD_NAME = "getAttribute";
    private static final String GET_TEST_INSTANCE_METHOD = "getTestInstance";

    public void prepareTestInstance(TestContext testContext) throws Exception {
        StepExecution stepExecution = this.getStepExecution(testContext);
        if (stepExecution != null) {
            Method method = TestContext.class.getMethod(SET_ATTRIBUTE_METHOD_NAME, String.class, Object.class);
            ReflectionUtils.invokeMethod((Method)method, (Object)testContext, (Object[])new Object[]{STEP_EXECUTION, stepExecution});
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method hasAttributeMethod = TestContext.class.getMethod(HAS_ATTRIBUTE_METHOD_NAME, String.class);
        Boolean hasAttribute = (Boolean)ReflectionUtils.invokeMethod((Method)hasAttributeMethod, (Object)testContext, (Object[])new Object[]{STEP_EXECUTION});
        if (hasAttribute.booleanValue()) {
            Method method = TestContext.class.getMethod(GET_ATTRIBUTE_METHOD_NAME, String.class);
            StepExecution stepExecution = (StepExecution)ReflectionUtils.invokeMethod((Method)method, (Object)testContext, (Object[])new Object[]{STEP_EXECUTION});
            StepSynchronizationManager.register((StepExecution)stepExecution);
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        Method method = TestContext.class.getMethod(HAS_ATTRIBUTE_METHOD_NAME, String.class);
        Boolean hasAttribute = (Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)testContext, (Object[])new Object[]{STEP_EXECUTION});
        if (hasAttribute.booleanValue()) {
            StepSynchronizationManager.close();
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
    }

    protected StepExecution getStepExecution(TestContext testContext) {
        Object target;
        Object method;
        try {
            method = TestContext.class.getMethod(GET_TEST_INSTANCE_METHOD, new Class[0]);
            target = ReflectionUtils.invokeMethod((Method)method, (Object)testContext);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method getTestInstance on provided TestContext", e);
        }
        method = new ExtractorMethodCallback(StepExecution.class, "getStepExecution");
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)method);
        if (((ExtractorMethodCallback)method).getName() != null) {
            HippyMethodInvoker invoker = new HippyMethodInvoker();
            invoker.setTargetObject(target);
            invoker.setTargetMethod(((ExtractorMethodCallback)method).getName());
            try {
                invoker.prepare();
                return (StepExecution)invoker.invoke();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create step execution from method: " + ((ExtractorMethodCallback)method).getName(), e);
            }
        }
        return MetaDataInstanceFactory.createStepExecution();
    }

    private final class ExtractorMethodCallback
    implements ReflectionUtils.MethodCallback {
        private String preferredName;
        private final Class<?> preferredType;
        private Method result;

        public ExtractorMethodCallback(Class<?> preferredType, String preferredName) {
            this.preferredType = preferredType;
            this.preferredName = preferredName;
        }

        public String getName() {
            return this.result == null ? null : this.result.getName();
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            Class<?> type = method.getReturnType();
            if (this.preferredType.isAssignableFrom(type) && (this.result == null || method.getName().equals(this.preferredName))) {
                this.result = method;
            }
        }
    }
}

