/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import org.springframework.boot.actuate.endpoint.cache.CachingConfiguration;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.core.env.Environment;

public class DefaultCachingConfigurationFactory
implements CachingConfigurationFactory {
    private final Environment environment;

    DefaultCachingConfigurationFactory(Environment environment) {
        this.environment = environment;
    }

    public CachingConfiguration getCachingConfiguration(String endpointId) {
        String key = String.format("endpoints.%s.cache.time-to-live", endpointId);
        Long timeToLive = (Long)this.environment.getProperty(key, Long.class, (Object)0L);
        return new CachingConfiguration(timeToLive.longValue());
    }
}

