/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.DefaultCachingConfigurationFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointProvider;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.OperationParameterMapper;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.convert.ConversionServiceOperationParameterMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebAnnotationEndpointDiscoverer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class EndpointAutoConfiguration {
    @Bean
    public OperationParameterMapper operationParameterMapper() {
        return new ConversionServiceOperationParameterMapper();
    }

    @Bean
    @ConditionalOnMissingBean(value={CachingConfigurationFactory.class})
    public DefaultCachingConfigurationFactory cacheConfigurationFactory(Environment environment) {
        return new DefaultCachingConfigurationFactory(environment);
    }

    @Configuration
    @ConditionalOnWebApplication
    static class EndpointWebConfiguration {
        private static final List<String> MEDIA_TYPES = Arrays.asList("application/vnd.spring-boot.actuator.v2+json", "application/json");
        private final ApplicationContext applicationContext;

        EndpointWebConfiguration(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Bean
        public EndpointProvider<WebEndpointOperation> webEndpointProvider(OperationParameterMapper parameterMapper, DefaultCachingConfigurationFactory cachingConfigurationFactory) {
            Environment environment = this.applicationContext.getEnvironment();
            WebAnnotationEndpointDiscoverer endpointDiscoverer = new WebAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, (CachingConfigurationFactory)cachingConfigurationFactory, MEDIA_TYPES, MEDIA_TYPES);
            return new EndpointProvider<WebEndpointOperation>(environment, (EndpointDiscoverer<WebEndpointOperation>)endpointDiscoverer, EndpointExposure.WEB);
        }
    }
}

