/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointEnablementProvider;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.core.env.Environment;

public class EndpointProvider<T extends Operation> {
    private final EndpointDiscoverer<T> discoverer;
    private final EndpointEnablementProvider endpointEnablementProvider;
    private final EndpointExposure exposure;

    public EndpointProvider(Environment environment, EndpointDiscoverer<T> discoverer, EndpointExposure exposure) {
        this.discoverer = discoverer;
        this.endpointEnablementProvider = new EndpointEnablementProvider(environment);
        this.exposure = exposure;
    }

    public Collection<EndpointInfo<T>> getEndpoints() {
        return this.discoverer.discoverEndpoints().stream().filter(this::isEnabled).collect(Collectors.toList());
    }

    private boolean isEnabled(EndpointInfo<?> endpoint) {
        return this.endpointEnablementProvider.getEndpointEnablement(endpoint.getId(), endpoint.getDefaultEnablement(), this.exposure).isEnabled();
    }
}

