/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web.jersey;

import java.util.HashSet;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.DefaultEndpointPathProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.EndpointPathProvider;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.jersey.JerseyEndpointResourceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={ResourceConfig.class})
@ConditionalOnBean(value={ResourceConfig.class})
@ConditionalOnMissingBean(type={"org.springframework.web.servlet.DispatcherServlet"})
class JerseyWebEndpointManagementContextConfiguration {
    JerseyWebEndpointManagementContextConfiguration() {
    }

    @Bean
    public ResourceConfigCustomizer webEndpointRegistrar(EndpointProvider<WebEndpointOperation> provider, ManagementServerProperties managementServerProperties) {
        return resourceConfig -> resourceConfig.registerResources(new HashSet(new JerseyEndpointResourceFactory().createEndpointResources(new EndpointMapping(managementServerProperties.getContextPath()), provider.getEndpoints())));
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointPathProvider endpointPathProvider(EndpointProvider<WebEndpointOperation> provider, ManagementServerProperties managementServerProperties) {
        return new DefaultEndpointPathProvider(provider, managementServerProperties);
    }
}

