/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.atlas;

import com.netflix.spectator.atlas.AtlasConfig;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import org.springframework.boot.actuate.autoconfigure.metrics.export.MetricsExporter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.StringToDurationConverter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.atlas.AtlasProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.atlas.AtlasPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={AtlasMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={AtlasProperties.class})
public class AtlasExportConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AtlasConfig.class})
    public AtlasConfig atlasConfig(AtlasProperties atlasProperties) {
        return new AtlasPropertiesConfigAdapter(atlasProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.atlas.enabled"}, matchIfMissing=true)
    public MetricsExporter atlasExporter(AtlasConfig atlasConfig, Clock clock) {
        return () -> new AtlasMeterRegistry(atlasConfig, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }
}

