/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.reactive;

import java.lang.reflect.Modifier;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.autoconfigure.web.reactive.ReactiveWebServerAutoConfiguration;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

class ReactiveManagementContextFactory
implements ManagementContextFactory {
    ReactiveManagementContextFactory() {
    }

    @Override
    public ConfigurableApplicationContext createManagementContext(ApplicationContext parent, Class<?> ... configClasses) {
        ReactiveWebServerApplicationContext child = new ReactiveWebServerApplicationContext();
        child.setParent(parent);
        child.register((Class[])configClasses);
        child.register(new Class[]{ReactiveWebServerAutoConfiguration.class});
        this.registerReactiveWebServerFactory(parent, (GenericReactiveWebApplicationContext)child);
        return child;
    }

    private void registerReactiveWebServerFactory(ApplicationContext parent, GenericReactiveWebApplicationContext childContext) {
        try {
            ConfigurableListableBeanFactory beanFactory = childContext.getBeanFactory();
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.registerBeanDefinition("ReactiveWebServerFactory", (BeanDefinition)new RootBeanDefinition(this.determineReactiveWebServerFactoryClass(parent)));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private Class<?> determineReactiveWebServerFactoryClass(ApplicationContext parent) throws NoSuchBeanDefinitionException {
        Class<?> factoryClass = ((ReactiveWebServerFactory)parent.getBean(ReactiveWebServerFactory.class)).getClass();
        if (this.cannotBeInstantiated(factoryClass)) {
            throw new FatalBeanException("ReactiveWebServerFactory implementation " + factoryClass.getName() + " cannot be instantiated. To allow a separate management port to be used, a top-level class or static inner class should be used instead");
        }
        return factoryClass;
    }

    private boolean cannotBeInstantiated(Class<?> factoryClass) {
        return factoryClass.isLocalClass() || factoryClass.isMemberClass() && !Modifier.isStatic(factoryClass.getModifiers()) || factoryClass.isAnonymousClass();
    }
}

