/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

class CompositeHandlerExceptionResolver
implements HandlerExceptionResolver {
    @Autowired
    private ListableBeanFactory beanFactory;
    private List<HandlerExceptionResolver> resolvers;

    CompositeHandlerExceptionResolver() {
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.resolvers == null) {
            this.resolvers = this.extractResolvers();
        }
        return this.resolvers.stream().map(resolver -> resolver.resolveException(request, response, handler, ex)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private List<HandlerExceptionResolver> extractResolvers() {
        ArrayList<HandlerExceptionResolver> list = new ArrayList<HandlerExceptionResolver>();
        list.addAll(this.beanFactory.getBeansOfType(HandlerExceptionResolver.class).values());
        list.remove(this);
        AnnotationAwareOrderComparator.sort(list);
        return list;
    }
}

