/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

@Endpoint(id="mappings")
public class RequestMappingEndpoint
implements ApplicationContextAware {
    private List<AbstractUrlHandlerMapping> handlerMappings = Collections.emptyList();
    private List<AbstractHandlerMethodMapping<?>> methodMappings = Collections.emptyList();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setHandlerMappings(List<AbstractUrlHandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
    }

    public void setMethodMappings(List<AbstractHandlerMethodMapping<?>> methodMappings) {
        this.methodMappings = methodMappings;
    }

    @ReadOperation
    public Map<String, Object> mappings() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.extractHandlerMappings(this.handlerMappings, result);
        this.extractHandlerMappings(this.applicationContext, result);
        this.extractMethodMappings(this.methodMappings, result);
        this.extractMethodMappings(this.applicationContext, result);
        return result;
    }

    protected void extractMethodMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            for (Map.Entry bean : applicationContext.getBeansOfType(AbstractHandlerMethodMapping.class).entrySet()) {
                Map methods = ((AbstractHandlerMethodMapping)bean.getValue()).getHandlerMethods();
                for (Map.Entry method : methods.entrySet()) {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("bean", bean.getKey());
                    map.put("method", ((HandlerMethod)method.getValue()).toString());
                    result.put(method.getKey().toString(), map);
                }
            }
        }
    }

    protected void extractHandlerMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            Map mappings = applicationContext.getBeansOfType(AbstractUrlHandlerMapping.class);
            for (Map.Entry mapping : mappings.entrySet()) {
                Map<String, Object> handlers = this.getHandlerMap((AbstractUrlHandlerMapping)mapping.getValue());
                for (Map.Entry<String, Object> handler : handlers.entrySet()) {
                    result.put(handler.getKey(), Collections.singletonMap("bean", mapping.getKey()));
                }
            }
        }
    }

    private Map<String, Object> getHandlerMap(AbstractUrlHandlerMapping mapping) {
        if (AopUtils.isCglibProxy((Object)mapping)) {
            return Collections.emptyMap();
        }
        return mapping.getHandlerMap();
    }

    protected void extractHandlerMappings(Collection<AbstractUrlHandlerMapping> handlerMappings, Map<String, Object> result) {
        for (AbstractUrlHandlerMapping mapping : handlerMappings) {
            Map handlers = mapping.getHandlerMap();
            for (Map.Entry entry : handlers.entrySet()) {
                Class<?> handlerClass = entry.getValue().getClass();
                result.put((String)entry.getKey(), Collections.singletonMap("type", handlerClass.getName()));
            }
        }
    }

    protected void extractMethodMappings(Collection<AbstractHandlerMethodMapping<?>> methodMappings, Map<String, Object> result) {
        for (AbstractHandlerMethodMapping<?> mapping : methodMappings) {
            Map methods = mapping.getHandlerMethods();
            for (Map.Entry entry : methods.entrySet()) {
                result.put(String.valueOf(entry.getKey()), Collections.singletonMap("method", String.valueOf(entry.getValue())));
            }
        }
    }
}

