/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import javax.servlet.Servlet;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ManagementServletContext;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ServletManagementContextFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.filter.ApplicationContextHeaderFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Servlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletManagementContextAutoConfiguration {
    @Bean
    public ServletManagementContextFactory servletWebChildContextFactory() {
        return new ServletManagementContextFactory();
    }

    @Bean
    public ManagementServletContext managementServletContext(ManagementServerProperties properties) {
        return () -> properties.getContextPath();
    }

    @Configuration
    @ConditionalOnProperty(prefix="management", name={"add-application-context-header"}, havingValue="true")
    protected static class ApplicationContextFilterConfiguration {
        protected ApplicationContextFilterConfiguration() {
        }

        @Bean
        public ApplicationContextHeaderFilter applicationContextIdFilter(ApplicationContext context) {
            return new ApplicationContextHeaderFilter(context);
        }
    }
}

