/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.audit;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.InMemoryAuditEventRepository;
import org.springframework.boot.actuate.audit.listener.AbstractAuditListener;
import org.springframework.boot.actuate.audit.listener.AuditListener;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.boot.actuate.security.AuthenticationAuditListener;
import org.springframework.boot.actuate.security.AuthorizationAuditListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuditAutoConfiguration {
    private final AuditEventRepository auditEventRepository;

    public AuditAutoConfiguration(ObjectProvider<AuditEventRepository> auditEventRepository) {
        this.auditEventRepository = (AuditEventRepository)auditEventRepository.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractAuditListener.class})
    public AuditListener auditListener() throws Exception {
        return new AuditListener(this.auditEventRepository);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.authentication.event.AbstractAuthenticationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthenticationAuditListener.class})
    public AuthenticationAuditListener authenticationAuditListener() throws Exception {
        return new AuthenticationAuditListener();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.access.event.AbstractAuthorizationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthorizationAuditListener.class})
    public AuthorizationAuditListener authorizationAuditListener() throws Exception {
        return new AuthorizationAuditListener();
    }

    @ConditionalOnMissingBean(value={AuditEventRepository.class})
    protected static class AuditEventRepositoryConfiguration {
        protected AuditEventRepositoryConfiguration() {
        }

        @Bean
        public InMemoryAuditEventRepository auditEventRepository() throws Exception {
            return new InMemoryAuditEventRepository();
        }
    }
}

