/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.SecurityResponse;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.reactive.AbstractWebFluxEndpointHandlerMapping;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class CloudFoundryWebFluxEndpointHandlerMapping
extends AbstractWebFluxEndpointHandlerMapping {
    private final Method handleRead = ReflectionUtils.findMethod(ReadOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class});
    private final Method handleWrite = ReflectionUtils.findMethod(WriteOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class, Map.class});
    private final Method links = ReflectionUtils.findMethod(((Object)((Object)this)).getClass(), (String)"links", (Class[])new Class[]{ServerWebExchange.class});
    private final EndpointLinksResolver endpointLinksResolver = new EndpointLinksResolver();
    private final ReactiveCloudFoundrySecurityInterceptor securityInterceptor;

    protected Method getLinks() {
        return this.links;
    }

    protected void registerMappingForOperation(WebEndpointOperation operation) {
        OperationType operationType = operation.getType();
        OperationInvoker operationInvoker = operation.getInvoker();
        if (operation.isBlocking()) {
            operationInvoker = new AbstractWebFluxEndpointHandlerMapping.ElasticSchedulerOperationInvoker(operationInvoker);
        }
        AbstractOperationHandler handler = operationType == OperationType.WRITE ? new WriteOperationHandler(operationInvoker, operation.getId()) : new ReadOperationHandler(operationInvoker, operation.getId());
        Method method = operationType == OperationType.WRITE ? this.handleWrite : this.handleRead;
        this.registerMapping(this.createRequestMappingInfo(operation), handler, method);
    }

    @ResponseBody
    private Publisher<ResponseEntity<Object>> links(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        return this.securityInterceptor.preHandle(exchange, "").map(securityResponse -> {
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return new ResponseEntity(securityResponse.getStatus());
            }
            AccessLevel accessLevel = (AccessLevel)((Object)((Object)exchange.getAttribute("cloudFoundryAccessLevel")));
            Map links = this.endpointLinksResolver.resolveLinks(this.getEndpoints(), request.getURI().toString());
            return new ResponseEntity(Collections.singletonMap("_links", this.getAccessibleLinks(accessLevel, links)), HttpStatus.OK);
        });
    }

    private Map<String, Link> getAccessibleLinks(AccessLevel accessLevel, Map<String, Link> links) {
        if (accessLevel == null) {
            return new LinkedHashMap<String, Link>();
        }
        return links.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("self") || accessLevel.isAccessAllowed((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    CloudFoundryWebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, ReactiveCloudFoundrySecurityInterceptor securityInterceptor) {
        super(endpointMapping, webEndpoints, endpointMediaTypes, corsConfiguration);
        this.securityInterceptor = securityInterceptor;
    }

    final class ReadOperationHandler
    extends AbstractOperationHandler {
        ReadOperationHandler(OperationInvoker operationInvoker, String endpointId) {
            super(operationInvoker, endpointId, CloudFoundryWebFluxEndpointHandlerMapping.this.securityInterceptor);
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange) {
            return this.doHandle(exchange, null);
        }
    }

    final class WriteOperationHandler
    extends AbstractOperationHandler {
        WriteOperationHandler(OperationInvoker operationInvoker, String endpointId) {
            super(operationInvoker, endpointId, CloudFoundryWebFluxEndpointHandlerMapping.this.securityInterceptor);
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange, @RequestBody(required=false) Map<String, String> body) {
            return this.doHandle(exchange, body);
        }
    }

    abstract class AbstractOperationHandler {
        private final OperationInvoker operationInvoker;
        private final String endpointId;
        private final ReactiveCloudFoundrySecurityInterceptor securityInterceptor;

        AbstractOperationHandler(OperationInvoker operationInvoker, String endpointId, ReactiveCloudFoundrySecurityInterceptor securityInterceptor) {
            this.operationInvoker = operationInvoker;
            this.endpointId = endpointId;
            this.securityInterceptor = securityInterceptor;
        }

        Publisher<ResponseEntity<Object>> doHandle(ServerWebExchange exchange, Map<String, String> body) {
            return this.securityInterceptor.preHandle(exchange, this.endpointId).flatMap(securityResponse -> this.flatMapResponse(exchange, body, (SecurityResponse)securityResponse));
        }

        private Mono<? extends ResponseEntity<Object>> flatMapResponse(ServerWebExchange exchange, Map<String, String> body, SecurityResponse securityResponse) {
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return Mono.just((Object)new ResponseEntity(securityResponse.getStatus()));
            }
            HashMap<String, String> arguments = new HashMap<String, String>((Map)exchange.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
            if (body != null) {
                arguments.putAll(body);
            }
            exchange.getRequest().getQueryParams().forEach((name, values) -> arguments.put((String)name, (String)(values.size() == 1 ? values.get(0) : values)));
            return this.handleResult((Publisher)this.operationInvoker.invoke(arguments), exchange.getRequest().getMethod());
        }

        private Mono<ResponseEntity<Object>> handleResult(Publisher<?> result, HttpMethod httpMethod) {
            return Mono.from(result).map(this::toResponseEntity).onErrorReturn(ParametersMissingException.class, (Object)new ResponseEntity(HttpStatus.BAD_REQUEST)).onErrorReturn(ParameterMappingException.class, (Object)new ResponseEntity(HttpStatus.BAD_REQUEST)).defaultIfEmpty((Object)new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT));
        }

        private ResponseEntity<Object> toResponseEntity(Object response) {
            if (!(response instanceof WebEndpointResponse)) {
                return new ResponseEntity(response, HttpStatus.OK);
            }
            WebEndpointResponse webEndpointResponse = (WebEndpointResponse)response;
            return new ResponseEntity(webEndpointResponse.getBody(), HttpStatus.valueOf((int)webEndpointResponse.getStatus()));
        }
    }
}

