/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.DefaultCachingConfigurationFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.DefaultEndpointPathResolver;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointProvider;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.ParameterMapper;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.convert.ConversionServiceParameterMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.EndpointPathResolver;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebAnnotationEndpointDiscoverer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class EndpointAutoConfiguration {
    @Bean
    public ParameterMapper endpointOperationParameterMapper() {
        return new ConversionServiceParameterMapper();
    }

    @Bean
    @ConditionalOnMissingBean(value={CachingConfigurationFactory.class})
    public DefaultCachingConfigurationFactory endpointCacheConfigurationFactory(Environment environment) {
        return new DefaultCachingConfigurationFactory(environment);
    }

    @Configuration
    @ConditionalOnWebApplication
    static class EndpointWebConfiguration {
        private static final List<String> MEDIA_TYPES = Arrays.asList("application/vnd.spring-boot.actuator.v2+json", "application/json");
        private final ApplicationContext applicationContext;

        EndpointWebConfiguration(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Bean
        public EndpointMediaTypes endpointMediaTypes() {
            return new EndpointMediaTypes(MEDIA_TYPES, MEDIA_TYPES);
        }

        @Bean
        @ConditionalOnMissingBean
        public EndpointPathResolver endpointPathResolver(Environment environment) {
            return new DefaultEndpointPathResolver(environment);
        }

        @Bean
        public EndpointProvider<WebEndpointOperation> webEndpointProvider(ParameterMapper parameterMapper, DefaultCachingConfigurationFactory cachingConfigurationFactory, EndpointPathResolver endpointPathResolver) {
            Environment environment = this.applicationContext.getEnvironment();
            WebAnnotationEndpointDiscoverer endpointDiscoverer = new WebAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, (CachingConfigurationFactory)cachingConfigurationFactory, this.endpointMediaTypes(), endpointPathResolver);
            return new EndpointProvider<WebEndpointOperation>(environment, (EndpointDiscoverer<WebEndpointOperation>)endpointDiscoverer, EndpointExposure.WEB);
        }
    }
}

