/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointProvider;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanRegistrar;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointMBeanFactory;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperationResponseMapper;

class JmxEndpointExporter
implements InitializingBean,
DisposableBean {
    private final EndpointProvider<JmxEndpointOperation> endpointProvider;
    private final EndpointMBeanRegistrar endpointMBeanRegistrar;
    private final JmxEndpointMBeanFactory mBeanFactory;
    private Collection<ObjectName> registeredObjectNames;

    JmxEndpointExporter(EndpointProvider<JmxEndpointOperation> endpointProvider, EndpointMBeanRegistrar endpointMBeanRegistrar, ObjectMapper objectMapper) {
        this.endpointProvider = endpointProvider;
        this.endpointMBeanRegistrar = endpointMBeanRegistrar;
        DataConverter dataConverter = new DataConverter(objectMapper);
        this.mBeanFactory = new JmxEndpointMBeanFactory((JmxOperationResponseMapper)dataConverter);
    }

    public void afterPropertiesSet() {
        this.registeredObjectNames = this.registerEndpointMBeans();
    }

    public void destroy() throws Exception {
        this.unregisterEndpointMBeans(this.registeredObjectNames);
    }

    private Collection<ObjectName> registerEndpointMBeans() {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        Collection mBeans = this.mBeanFactory.createMBeans(this.endpointProvider.getEndpoints());
        for (EndpointMBean mBean : mBeans) {
            objectNames.add(this.endpointMBeanRegistrar.registerEndpointMBean(mBean));
        }
        return objectNames;
    }

    private void unregisterEndpointMBeans(Collection<ObjectName> objectNames) {
        objectNames.forEach(arg_0 -> ((EndpointMBeanRegistrar)this.endpointMBeanRegistrar).unregisterEndpointMbean(arg_0));
    }

    static class DataConverter
    implements JmxOperationResponseMapper {
        private final ObjectMapper objectMapper;
        private final JavaType listObject;
        private final JavaType mapStringObject;

        DataConverter(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper == null ? new ObjectMapper() : objectMapper;
            this.listObject = this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Object.class});
            this.mapStringObject = this.objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, Object.class});
        }

        public Object mapResponse(Object response) {
            if (response == null) {
                return null;
            }
            if (response instanceof String) {
                return response;
            }
            if (response.getClass().isArray() || response instanceof Collection) {
                return this.objectMapper.convertValue(response, this.listObject);
            }
            return this.objectMapper.convertValue(response, this.mapStringObject);
        }

        public Class<?> mapResponseType(Class<?> responseType) {
            if (responseType.equals(String.class)) {
                return String.class;
            }
            if (responseType.isArray() || Collection.class.isAssignableFrom(responseType)) {
                return List.class;
            }
            return Map.class;
        }
    }
}

