/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.EndpointPathProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.util.Assert;

public class DefaultEndpointPathProvider
implements EndpointPathProvider {
    private final Collection<EndpointInfo<WebEndpointOperation>> endpoints;
    private final String basePath;

    public DefaultEndpointPathProvider(EndpointProvider<WebEndpointOperation> provider, WebEndpointProperties webEndpointProperties) {
        this.endpoints = provider.getEndpoints();
        this.basePath = webEndpointProperties.getBasePath();
    }

    @Override
    public List<String> getPaths() {
        return this.endpoints.stream().map(this::getPath).collect(Collectors.toList());
    }

    @Override
    public String getPath(String id) {
        Assert.notNull((Object)id, (String)"ID must not be null");
        return this.endpoints.stream().filter(info -> id.equals(info.getId())).findFirst().map(this::getPath).orElse(null);
    }

    private String getPath(EndpointInfo<WebEndpointOperation> endpointInfo) {
        return this.basePath + "/" + endpointInfo.getId();
    }
}

