/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.web.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.metrics.web.servlet.DefaultWebMvcTagsProvider;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcMetrics;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcMetricsFilter;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class WebMvcMetricsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WebMvcTagsProvider.class})
    public DefaultWebMvcTagsProvider webmvcTagConfigurer() {
        return new DefaultWebMvcTagsProvider();
    }

    @Bean
    public WebMvcMetrics controllerMetrics(MeterRegistry registry, MetricsProperties properties, WebMvcTagsProvider configurer) {
        return new WebMvcMetrics(registry, configurer, properties.getWeb().getServer().getRequestsMetricName(), properties.getWeb().getServer().isAutoTimeRequests(), properties.getWeb().getServer().isRecordRequestPercentiles());
    }

    @Bean
    public WebMvcMetricsFilter webMetricsFilter(WebMvcMetrics controllerMetrics, HandlerMappingIntrospector introspector) {
        return new WebMvcMetricsFilter(controllerMetrics, introspector);
    }
}

