/*
 * Copyright 2012-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.autoconfigure.metrics.export.influx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Configuration for exporting metrics to Influx.
 *
 * @author Jon Schneider
 * @since 2.0.0
 */
@Configuration
@ConditionalOnClass(InfluxMeterRegistry.class)
@EnableConfigurationProperties(InfluxProperties.class)
public class InfluxExportConfiguration {

	@Bean
	@ConditionalOnMissingBean(InfluxConfig.class)
	public InfluxConfig influxConfig(InfluxProperties influxProperties) {
		return new InfluxPropertiesConfigAdapter(influxProperties);
	}

	@Bean
	@ConditionalOnProperty(value = "management.metrics.export.influx.enabled", matchIfMissing = true)
	public InfluxMeterRegistry influxMeterRegistry(InfluxConfig influxConfig,
			Clock clock) {
		return new InfluxMeterRegistry(influxConfig, clock);
	}

}
