/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

@Order(value=0x7FFFFFFF)
class ManagementContextConfigurationImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware {
    private ClassLoader classLoader;

    ManagementContextConfigurationImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        ManagementContextType contextType = (ManagementContextType)((Object)metadata.getAnnotationAttributes(EnableManagementContext.class.getName()).get("value"));
        List<ManagementConfiguration> configurations = this.getConfigurations();
        OrderComparator.sort(configurations);
        ArrayList<String> names = new ArrayList<String>();
        for (ManagementConfiguration configuration : configurations) {
            if (configuration.getContextType() != ManagementContextType.ANY && configuration.getContextType() != contextType) continue;
            names.add(configuration.getClassName());
        }
        return names.toArray(new String[names.size()]);
    }

    private List<ManagementConfiguration> getConfigurations() {
        SimpleMetadataReaderFactory readerFactory = new SimpleMetadataReaderFactory(this.classLoader);
        ArrayList<ManagementConfiguration> configurations = new ArrayList<ManagementConfiguration>();
        for (String className : this.loadFactoryNames()) {
            this.addConfiguration(readerFactory, configurations, className);
        }
        return configurations;
    }

    private void addConfiguration(SimpleMetadataReaderFactory readerFactory, List<ManagementConfiguration> configurations, String className) {
        try {
            MetadataReader metadataReader = readerFactory.getMetadataReader(className);
            configurations.add(new ManagementConfiguration(metadataReader));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read annotation metadata for '" + className + "'", ex);
        }
    }

    protected List<String> loadFactoryNames() {
        return SpringFactoriesLoader.loadFactoryNames(ManagementContextConfiguration.class, (ClassLoader)this.classLoader);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static final class ManagementConfiguration
    implements Ordered {
        private final String className;
        private final int order;
        private final ManagementContextType contextType;

        ManagementConfiguration(MetadataReader metadataReader) {
            AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
            this.order = this.readOrder(annotationMetadata);
            this.className = metadataReader.getClassMetadata().getClassName();
            this.contextType = this.readContextType(annotationMetadata);
        }

        private ManagementContextType readContextType(AnnotationMetadata annotationMetadata) {
            Map annotationAttributes = annotationMetadata.getAnnotationAttributes(ManagementContextConfiguration.class.getName());
            return annotationAttributes == null ? ManagementContextType.ANY : (ManagementContextType)((Object)annotationAttributes.get("value"));
        }

        private int readOrder(AnnotationMetadata annotationMetadata) {
            Map attributes = annotationMetadata.getAnnotationAttributes(Order.class.getName());
            Integer order = attributes == null ? null : (Integer)attributes.get("value");
            return order == null ? Integer.MAX_VALUE : order;
        }

        public String getClassName() {
            return this.className;
        }

        public int getOrder() {
            return this.order;
        }

        public ManagementContextType getContextType() {
            return this.contextType;
        }
    }
}

