/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaConsumerMetrics;
import java.util.Collections;
import javax.management.MBeanServer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, JmxAutoConfiguration.class})
@ConditionalOnClass(value={KafkaConsumerMetrics.class, KafkaConsumer.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class KafkaMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MBeanServer.class})
    public KafkaConsumerMetrics kafkaConsumerMetrics(MBeanServer mbeanServer) {
        return new KafkaConsumerMetrics(mbeanServer, Collections.emptyList());
    }
}

