/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.health.CompositeReactiveHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointWebExtension;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.HealthWebEndpointResponseMapper;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthEndpointWebExtension;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HealthIndicatorProperties.class})
class HealthEndpointWebExtensionConfiguration {
    HealthEndpointWebExtensionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthStatusHttpMapper createHealthStatusHttpMapper(HealthIndicatorProperties healthIndicatorProperties) {
        HealthStatusHttpMapper statusHttpMapper = new HealthStatusHttpMapper();
        if (healthIndicatorProperties.getHttpMapping() != null) {
            statusHttpMapper.addStatusMapping(healthIndicatorProperties.getHttpMapping());
        }
        return statusHttpMapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthWebEndpointResponseMapper healthWebEndpointResponseMapper(HealthStatusHttpMapper statusHttpMapper, HealthEndpointProperties properties) {
        return new HealthWebEndpointResponseMapper(statusHttpMapper, properties.getShowDetails(), properties.getRoles());
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnEnabledEndpoint(endpoint=HealthEndpoint.class)
    static class ServletWebHealthConfiguration {
        ServletWebHealthConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={HealthEndpoint.class})
        public HealthEndpointWebExtension healthEndpointWebExtension(HealthEndpoint healthEndpoint, HealthWebEndpointResponseMapper responseMapper) {
            return new HealthEndpointWebExtension(healthEndpoint, responseMapper);
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnSingleCandidate(value=ReactiveHealthIndicatorRegistry.class)
    @ConditionalOnEnabledEndpoint(endpoint=HealthEndpoint.class)
    static class ReactiveWebHealthConfiguration {
        private final ReactiveHealthIndicator reactiveHealthIndicator;

        ReactiveWebHealthConfiguration(ObjectProvider<HealthAggregator> healthAggregator, ReactiveHealthIndicatorRegistry registry) {
            this.reactiveHealthIndicator = new CompositeReactiveHealthIndicator((HealthAggregator)healthAggregator.getIfAvailable(OrderedHealthAggregator::new), registry);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={HealthEndpoint.class})
        public ReactiveHealthEndpointWebExtension reactiveHealthEndpointWebExtension(HealthWebEndpointResponseMapper responseMapper) {
            return new ReactiveHealthEndpointWebExtension(this.reactiveHealthIndicator, responseMapper);
        }
    }
}

