/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.jmx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.jmx.JmxProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.jmx.JmxPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={JmxMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={JmxProperties.class})
public class JmxMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JmxConfig jmxConfig(JmxProperties jmxProperties) {
        return new JmxPropertiesConfigAdapter(jmxProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public JmxMeterRegistry jmxMeterRegistry(JmxConfig jmxConfig, Clock clock) {
        return new JmxMeterRegistry(jmxConfig, clock);
    }
}

