/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.couchbase;

import com.couchbase.client.java.Cluster;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.couchbase.CouchbaseHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Cluster.class})
@ConditionalOnBean(value={Cluster.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={CouchbaseAutoConfiguration.class})
public class CouchbaseHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<CouchbaseHealthIndicator, Cluster> {
    @Bean
    @ConditionalOnMissingBean(name={"couchbaseHealthIndicator"})
    public HealthIndicator couchbaseHealthIndicator(Map<String, Cluster> clusters) {
        return this.createHealthIndicator(clusters);
    }

    @Override
    protected CouchbaseHealthIndicator createHealthIndicator(Cluster cluster) {
        return new CouchbaseHealthIndicator(cluster);
    }
}

