/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cache;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnExposedEndpoint;
import org.springframework.boot.actuate.cache.CachesEndpoint;
import org.springframework.boot.actuate.cache.CachesEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnEnabledEndpoint(endpoint=CachesEndpoint.class)
@ConditionalOnExposedEndpoint(endpoint=CachesEndpoint.class)
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
public class CachesEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CachesEndpoint cachesEndpoint(Map<String, CacheManager> cacheManagers) {
        return new CachesEndpoint(cacheManagers);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={CachesEndpoint.class})
    public CachesEndpointWebExtension cachesEndpointWebExtension(CachesEndpoint cachesEndpoint) {
        return new CachesEndpointWebExtension(cachesEndpoint);
    }
}

