/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.elasticsearch;

import java.time.Duration;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticsearchHealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Client.class})
@ConditionalOnBean(value={Client.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={ElasticsearchAutoConfiguration.class})
@EnableConfigurationProperties(value={ElasticsearchHealthIndicatorProperties.class})
public class ElasticSearchClientHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<ElasticsearchHealthIndicator, Client> {
    private final ElasticsearchHealthIndicatorProperties properties;

    public ElasticSearchClientHealthIndicatorAutoConfiguration(ElasticsearchHealthIndicatorProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
    public HealthIndicator elasticsearchHealthIndicator(Map<String, Client> clients) {
        return this.createHealthIndicator(clients);
    }

    @Override
    protected ElasticsearchHealthIndicator createHealthIndicator(Client client) {
        Duration responseTimeout = this.properties.getResponseTimeout();
        return new ElasticsearchHealthIndicator(client, responseTimeout != null ? responseTimeout.toMillis() : 100L, this.properties.getIndices());
    }
}

