/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.elasticsearch;

import io.searchbox.client.JestClient;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticSearchClientHealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchJestHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.jest.JestAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JestClient.class})
@ConditionalOnBean(value={JestClient.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={JestAutoConfiguration.class, ElasticSearchClientHealthIndicatorAutoConfiguration.class})
public class ElasticSearchJestHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<ElasticsearchJestHealthIndicator, JestClient> {
    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
    public HealthIndicator elasticsearchHealthIndicator(Map<String, JestClient> clients) {
        return this.createHealthIndicator(clients);
    }

    @Override
    protected ElasticsearchJestHealthIndicator createHealthIndicator(JestClient client) {
        return new ElasticsearchJestHealthIndicator(client);
    }
}

