/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.ExposeExcludePropertyEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.MappingWebEndpointPathMapper;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ExposableControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@AutoConfigureAfter(value={EndpointAutoConfiguration.class})
@EnableConfigurationProperties(value={WebEndpointProperties.class})
public class WebEndpointAutoConfiguration {
    private static final List<String> MEDIA_TYPES = Arrays.asList("application/vnd.spring-boot.actuator.v2+json", "application/json");
    private final ApplicationContext applicationContext;
    private final WebEndpointProperties properties;

    public WebEndpointAutoConfiguration(ApplicationContext applicationContext, WebEndpointProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    public PathMapper webEndpointPathMapper() {
        return new MappingWebEndpointPathMapper(this.properties.getPathMapping());
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointMediaTypes endpointMediaTypes() {
        return new EndpointMediaTypes(MEDIA_TYPES, MEDIA_TYPES);
    }

    @Bean
    @ConditionalOnMissingBean(value={WebEndpointsSupplier.class})
    public WebEndpointDiscoverer webEndpointDiscoverer(ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<OperationInvokerAdvisor> invokerAdvisors, ObjectProvider<EndpointFilter<ExposableWebEndpoint>> filters) {
        return new WebEndpointDiscoverer(this.applicationContext, parameterValueMapper, endpointMediaTypes, endpointPathMappers.orderedStream().collect(Collectors.toList()), (Collection)invokerAdvisors.orderedStream().collect(Collectors.toList()), (Collection)filters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnMissingBean(value={ControllerEndpointsSupplier.class})
    public ControllerEndpointDiscoverer controllerEndpointDiscoverer(ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<Collection<EndpointFilter<ExposableControllerEndpoint>>> filters) {
        return new ControllerEndpointDiscoverer(this.applicationContext, endpointPathMappers.orderedStream().collect(Collectors.toList()), (Collection)filters.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConditionalOnMissingBean
    public PathMappedEndpoints pathMappedEndpoints(Collection<EndpointsSupplier<?>> endpointSuppliers, WebEndpointProperties webEndpointProperties) {
        return new PathMappedEndpoints(webEndpointProperties.getBasePath(), endpointSuppliers);
    }

    @Bean
    public ExposeExcludePropertyEndpointFilter<ExposableWebEndpoint> webExposeExcludePropertyEndpointFilter() {
        WebEndpointProperties.Exposure exposure = this.properties.getExposure();
        return new ExposeExcludePropertyEndpointFilter<ExposableWebEndpoint>(ExposableWebEndpoint.class, exposure.getInclude(), exposure.getExclude(), "info", "health");
    }

    @Bean
    public ExposeExcludePropertyEndpointFilter<ExposableControllerEndpoint> controllerExposeExcludePropertyEndpointFilter() {
        WebEndpointProperties.Exposure exposure = this.properties.getExposure();
        return new ExposeExcludePropertyEndpointFilter<ExposableControllerEndpoint>(ExposableControllerEndpoint.class, exposure.getInclude(), exposure.getExclude(), new String[0]);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class WebEndpointServletConfiguration {
        WebEndpointServletConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ServletEndpointsSupplier.class})
        public ServletEndpointDiscoverer servletEndpointDiscoverer(ApplicationContext applicationContext, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<EndpointFilter<ExposableServletEndpoint>> filters) {
            return new ServletEndpointDiscoverer(applicationContext, endpointPathMappers.orderedStream().collect(Collectors.toList()), (Collection)filters.orderedStream().collect(Collectors.toList()));
        }
    }
}

