/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.AbstractEndpointCondition;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnExposedEndpoint;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnExposedEndpointCondition
extends AbstractEndpointCondition {
    private static final String JMX_ENABLED_KEY = "spring.jmx.enabled";
    private static final ConcurrentReferenceHashMap<Environment, Set<ExposureInformation>> endpointExposureCache = new ConcurrentReferenceHashMap();

    OnExposedEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive(environment)) {
            return new ConditionOutcome(true, ConditionMessage.forCondition(ConditionalOnExposedEndpoint.class, (Object[])new Object[0]).because("application is running on Cloud Foundry"));
        }
        AnnotationAttributes attributes = this.getEndpointAttributes(ConditionalOnExposedEndpoint.class, context, metadata);
        EndpointId id = EndpointId.of((String)attributes.getString("id"));
        Set<ExposureInformation> exposureInformations = this.getExposureInformation(environment);
        for (ExposureInformation exposureInformation : exposureInformations) {
            if (!exposureInformation.isExposed(id)) continue;
            return new ConditionOutcome(true, ConditionMessage.forCondition(ConditionalOnExposedEndpoint.class, (Object[])new Object[0]).because("marked as exposed by a 'management.endpoints." + exposureInformation.getPrefix() + ".exposure' property"));
        }
        return new ConditionOutcome(false, ConditionMessage.forCondition(ConditionalOnExposedEndpoint.class, (Object[])new Object[0]).because("no 'management.endpoints' property marked it as exposed"));
    }

    private Set<ExposureInformation> getExposureInformation(Environment environment) {
        HashSet<ExposureInformation> exposureInformations = (HashSet<ExposureInformation>)endpointExposureCache.get((Object)environment);
        if (exposureInformations == null) {
            exposureInformations = new HashSet<ExposureInformation>(2);
            Binder binder = Binder.get((Environment)environment);
            if (((Boolean)environment.getProperty(JMX_ENABLED_KEY, Boolean.class, (Object)false)).booleanValue()) {
                exposureInformations.add(new ExposureInformation(binder, "jmx", "*"));
            }
            exposureInformations.add(new ExposureInformation(binder, "web", "info", "health"));
            endpointExposureCache.put((Object)environment, exposureInformations);
        }
        return exposureInformations;
    }

    static class ExposureInformation {
        private final String prefix;
        private final Set<String> include;
        private final Set<String> exclude;
        private final Set<String> exposeDefaults;

        ExposureInformation(Binder binder, String prefix, String ... exposeDefaults) {
            this.prefix = prefix;
            this.include = this.bind(binder, "management.endpoints." + prefix + ".exposure.include");
            this.exclude = this.bind(binder, "management.endpoints." + prefix + ".exposure.exclude");
            this.exposeDefaults = new HashSet<String>(Arrays.asList(exposeDefaults));
        }

        private Set<String> bind(Binder binder, String name) {
            List values = (List)binder.bind(name, Bindable.listOf(String.class)).orElse(Collections.emptyList());
            HashSet<String> result = new HashSet<String>(values.size());
            for (String value : values) {
                result.add("*".equals(value) ? "*" : EndpointId.fromPropertyValue((String)value).toLowerCaseString());
            }
            return result;
        }

        String getPrefix() {
            return this.prefix;
        }

        boolean isExposed(EndpointId endpointId) {
            String id = endpointId.toLowerCaseString();
            if (!this.exclude.isEmpty() && (this.exclude.contains("*") || this.exclude.contains(id))) {
                return false;
            }
            if (this.include.isEmpty() && (this.exposeDefaults.contains("*") || this.exposeDefaults.contains(id))) {
                return true;
            }
            return this.include.contains("*") || this.include.contains(id);
        }
    }
}

