/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.elasticsearch;

import java.util.Map;
import org.elasticsearch.client.RestClient;
import org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticSearchClientHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.elasticsearch.ElasticsearchRestHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.rest.RestClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RestClient.class})
@ConditionalOnBean(value={RestClient.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
@AutoConfigureAfter(value={RestClientAutoConfiguration.class, ElasticSearchClientHealthContributorAutoConfiguration.class})
public class ElasticSearchRestHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<ElasticsearchRestHealthIndicator, RestClient> {
    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchRestHealthIndicator", "elasticsearchRestHealthContributor"})
    public HealthContributor elasticsearchRestHealthContributor(Map<String, RestClient> clients) {
        return (HealthContributor)this.createContributor(clients);
    }
}

