/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import com.zaxxer.hikari.HikariConfigMXBean;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogMessage;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={DataSource.class, MeterRegistry.class})
public class DataSourcePoolMetricsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HikariDataSource.class})
    static class HikariDataSourceMetricsConfiguration {
        HikariDataSourceMetricsConfiguration() {
        }

        @Bean
        HikariDataSourceMeterBinder hikariDataSourceMeterBinder(ObjectProvider<DataSource> dataSources) {
            return new HikariDataSourceMeterBinder(dataSources);
        }

        static class HikariDataSourceMeterBinder
        implements MeterBinder {
            private static final Log logger = LogFactory.getLog(HikariDataSourceMeterBinder.class);
            private final ObjectProvider<DataSource> dataSources;

            HikariDataSourceMeterBinder(ObjectProvider<DataSource> dataSources) {
                this.dataSources = dataSources;
            }

            public void bindTo(MeterRegistry registry) {
                for (DataSource dataSource : this.dataSources) {
                    HikariDataSource hikariDataSource = (HikariDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, HikariConfigMXBean.class, HikariDataSource.class);
                    if (hikariDataSource == null) continue;
                    this.bindMetricsRegistryToHikariDataSource(hikariDataSource, registry);
                }
            }

            private void bindMetricsRegistryToHikariDataSource(HikariDataSource hikari, MeterRegistry registry) {
                if (hikari.getMetricRegistry() == null && hikari.getMetricsTrackerFactory() == null) {
                    try {
                        hikari.setMetricsTrackerFactory((MetricsTrackerFactory)new MicrometerMetricsTrackerFactory(registry));
                    }
                    catch (Exception ex) {
                        logger.warn((Object)LogMessage.format((String)"Failed to bind Hikari metrics: %s", (Object)ex.getMessage()));
                    }
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={DataSourcePoolMetadataProvider.class})
    static class DataSourcePoolMetadataMetricsConfiguration {
        private static final String DATASOURCE_SUFFIX = "dataSource";

        DataSourcePoolMetadataMetricsConfiguration() {
        }

        @Bean
        DataSourcePoolMetadataMeterBinder dataSourcePoolMetadataMeterBinder(Map<String, DataSource> dataSources, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
            return new DataSourcePoolMetadataMeterBinder(dataSources, metadataProviders);
        }

        static class DataSourcePoolMetadataMeterBinder
        implements MeterBinder {
            private final Map<String, DataSource> dataSources;
            private final ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders;

            DataSourcePoolMetadataMeterBinder(Map<String, DataSource> dataSources, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
                this.dataSources = dataSources;
                this.metadataProviders = metadataProviders;
            }

            public void bindTo(MeterRegistry registry) {
                List metadataProvidersList = this.metadataProviders.stream().collect(Collectors.toList());
                this.dataSources.forEach((name, dataSource) -> this.bindDataSourceToRegistry((String)name, (DataSource)dataSource, metadataProvidersList, registry));
            }

            private void bindDataSourceToRegistry(String beanName, DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, MeterRegistry registry) {
                String dataSourceName = this.getDataSourceName(beanName);
                new DataSourcePoolMetrics(dataSource, metadataProviders, dataSourceName, Collections.emptyList()).bindTo(registry);
            }

            private String getDataSourceName(String beanName) {
                if (beanName.length() > DataSourcePoolMetadataMetricsConfiguration.DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DataSourcePoolMetadataMetricsConfiguration.DATASOURCE_SUFFIX)) {
                    return beanName.substring(0, beanName.length() - DataSourcePoolMetadataMetricsConfiguration.DATASOURCE_SUFFIX.length());
                }
                return beanName;
            }
        }
    }
}

