/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.otlp;

import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpProperties;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class OtlpTracingConfigurations {
    OtlpTracingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class Exporters {
        Exporters() {
        }

        @Bean
        @ConditionalOnMissingBean(value={OtlpHttpSpanExporter.class}, type={"io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter"})
        @ConditionalOnBean(value={OtlpTracingConnectionDetails.class})
        @ConditionalOnEnabledTracing
        OtlpHttpSpanExporter otlpHttpSpanExporter(OtlpProperties properties, OtlpTracingConnectionDetails connectionDetails) {
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder().setEndpoint(connectionDetails.getUrl()).setTimeout(properties.getTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.ROOT));
            for (Map.Entry<String, String> header : properties.getHeaders().entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ConnectionDetails {
        ConnectionDetails() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="management.otlp.tracing", name={"endpoint"})
        OtlpTracingConnectionDetails otlpTracingConnectionDetails(OtlpProperties properties) {
            return new PropertiesOtlpTracingConnectionDetails(properties);
        }

        static class PropertiesOtlpTracingConnectionDetails
        implements OtlpTracingConnectionDetails {
            private final OtlpProperties properties;

            PropertiesOtlpTracingConnectionDetails(OtlpProperties properties) {
                this.properties = properties;
            }

            @Override
            public String getUrl() {
                return this.properties.getEndpoint();
            }
        }
    }
}

