/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthEndpointGroups;
import org.springframework.boot.actuate.autoconfigure.health.GroupsHealthContributorNameValidator;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointGroupsPostProcessor;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.registry.HealthContributorRegistry;
import org.springframework.boot.health.registry.ReactiveHealthContributorRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
class HealthEndpointConfiguration {
    HealthEndpointConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    StatusAggregator healthStatusAggregator(HealthEndpointProperties properties) {
        return new SimpleStatusAggregator(properties.getStatus().getOrder());
    }

    @Bean
    @ConditionalOnMissingBean
    HttpCodeStatusMapper healthHttpCodeStatusMapper(HealthEndpointProperties properties) {
        return new SimpleHttpCodeStatusMapper(properties.getStatus().getHttpMapping());
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthEndpointGroups.class})
    AutoConfiguredHealthEndpointGroups healthEndpointGroups(ApplicationContext applicationContext, HealthEndpointProperties properties) {
        return new AutoConfiguredHealthEndpointGroups(applicationContext, properties);
    }

    @Bean
    GroupsHealthContributorNameValidator groupsHealthContributorNameValidator(ObjectProvider<HealthEndpointGroups> healthEndpointGroups) {
        return new GroupsHealthContributorNameValidator((HealthEndpointGroups)healthEndpointGroups.getIfAvailable());
    }

    @Bean
    @ConditionalOnBooleanProperty(name={"management.endpoint.health.validate-group-membership"}, matchIfMissing=true)
    HealthEndpointGroupMembershipValidator healthEndpointGroupMembershipValidator(HealthEndpointProperties properties, HealthContributorRegistry healthContributorRegistry) {
        return new HealthEndpointGroupMembershipValidator(properties, healthContributorRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpoint healthEndpoint(HealthContributorRegistry halthContributorRegistry, ObjectProvider<ReactiveHealthContributorRegistry> reactiveHealthContributorRegistry, HealthEndpointGroups groups, HealthEndpointProperties properties) {
        return new HealthEndpoint(halthContributorRegistry, (ReactiveHealthContributorRegistry)reactiveHealthContributorRegistry.getIfAvailable(), groups, properties.getLogging().getSlowIndicatorThreshold());
    }

    @Bean
    static HealthEndpointGroupsBeanPostProcessor healthEndpointGroupsBeanPostProcessor(ObjectProvider<HealthEndpointGroupsPostProcessor> healthEndpointGroupsPostProcessors) {
        return new HealthEndpointGroupsBeanPostProcessor(healthEndpointGroupsPostProcessors);
    }

    static class HealthEndpointGroupMembershipValidator
    implements SmartInitializingSingleton {
        private final HealthEndpointProperties properties;
        private final HealthContributorRegistry registry;

        HealthEndpointGroupMembershipValidator(HealthEndpointProperties properties, HealthContributorRegistry registry) {
            this.properties = properties;
            this.registry = registry;
        }

        public void afterSingletonsInstantiated() {
            this.validateGroups();
        }

        private void validateGroups() {
            this.properties.getGroup().forEach((name, group) -> {
                this.validate(group.getInclude(), "Included", (String)name);
                this.validate(group.getExclude(), "Excluded", (String)name);
            });
        }

        private void validate(Set<String> names, String type, String group) {
            if (CollectionUtils.isEmpty(names)) {
                return;
            }
            for (String name : names) {
                if ("*".equals(name)) {
                    return;
                }
                String[] path = name.split("/");
                if (this.contributorExists(path)) continue;
                throw new NoSuchHealthContributorException(type, name, group);
            }
        }

        private boolean contributorExists(String[] path) {
            HealthContributorRegistry contributor = this.registry;
            for (int pathOffset = 0; pathOffset < path.length; ++pathOffset) {
                if (!(contributor instanceof HealthContributors)) {
                    return false;
                }
                contributor = ((HealthContributors)contributor).getContributor(path[pathOffset]);
            }
            return contributor != null;
        }

        static class NoSuchHealthContributorException
        extends RuntimeException {
            NoSuchHealthContributorException(String type, String name, String group) {
                super(type + " health contributor '" + name + "' in group '" + group + "' does not exist");
            }
        }
    }

    static class HealthEndpointGroupsBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<HealthEndpointGroupsPostProcessor> postProcessors;

        HealthEndpointGroupsBeanPostProcessor(ObjectProvider<HealthEndpointGroupsPostProcessor> postProcessors) {
            this.postProcessors = postProcessors;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof HealthEndpointGroups) {
                HealthEndpointGroups groups = (HealthEndpointGroups)bean;
                return this.applyPostProcessors(groups);
            }
            return bean;
        }

        private Object applyPostProcessors(HealthEndpointGroups bean) {
            for (HealthEndpointGroupsPostProcessor postProcessor : (HealthEndpointGroupsPostProcessor[])this.postProcessors.orderedStream().toArray(HealthEndpointGroupsPostProcessor[]::new)) {
                bean = postProcessor.postProcessHealthEndpointGroups(bean);
            }
            return bean;
        }
    }
}

