/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointWebMvcChildContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerPropertiesAutoConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerAdapter;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.properties.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.properties.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureAfter(value={PropertyPlaceholderAutoConfiguration.class, EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, ManagementServerPropertiesAutoConfiguration.class})
public class EndpointWebMvcAutoConfiguration
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Integer DISABLED_PORT = 0;
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private ManagementServerProperties managementServerProperties = new ManagementServerProperties();

    @Bean
    @ConditionalOnMissingBean
    public EndpointHandlerMapping endpointHandlerMapping() {
        EndpointHandlerMapping mapping = new EndpointHandlerMapping();
        mapping.setDisabled(ManagementServerPort.get((BeanFactory)this.applicationContext) != ManagementServerPort.SAME);
        mapping.setPrefix(this.managementServerProperties.getContextPath());
        return mapping;
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointHandlerAdapter endpointHandlerAdapter() {
        return new EndpointHandlerAdapter();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext && ManagementServerPort.get((BeanFactory)this.applicationContext) == ManagementServerPort.DIFFERENT) {
            this.createChildManagementContext();
        }
    }

    @Bean
    public Filter applicationContextIdFilter(ApplicationContext context) {
        final String id = context.getId();
        return new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                response.addHeader("X-Application-Context", id);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        };
    }

    private void createChildManagementContext() {
        final AnnotationConfigEmbeddedWebApplicationContext childContext = new AnnotationConfigEmbeddedWebApplicationContext();
        childContext.setParent(this.applicationContext);
        childContext.setId(this.applicationContext.getId() + ":management");
        childContext.register(new Class[]{EndpointWebMvcChildContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class, EmbeddedServletContainerAutoConfiguration.class});
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).addApplicationListener((ApplicationListener)new ApplicationListener<ContextClosedEvent>(){

                public void onApplicationEvent(ContextClosedEvent event) {
                    if (event.getApplicationContext() == EndpointWebMvcAutoConfiguration.this.applicationContext) {
                        childContext.close();
                    }
                }
            });
        }
        childContext.refresh();
    }

    private static enum ManagementServerPort {
        DISABLE,
        SAME,
        DIFFERENT;


        public static ManagementServerPort get(BeanFactory beanFactory) {
            ManagementServerProperties managementServerProperties;
            ServerProperties serverProperties;
            try {
                serverProperties = (ServerProperties)beanFactory.getBean(ServerProperties.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                serverProperties = new ServerProperties();
            }
            try {
                managementServerProperties = (ManagementServerProperties)beanFactory.getBean(ManagementServerProperties.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                managementServerProperties = new ManagementServerProperties();
            }
            if (DISABLED_PORT.equals(managementServerProperties.getPort())) {
                return DISABLE;
            }
            return managementServerProperties.getPort() == null || serverProperties.getPort() == managementServerProperties.getPort().intValue() ? SAME : DIFFERENT;
        }
    }
}

