/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.LiveBeansView;
import org.springframework.http.MediaType;

@ConfigurationProperties(name="endpoints.beans", ignoreUnknownFields=false)
public class BeansEndpoint
extends AbstractEndpoint<String>
implements ApplicationContextAware {
    private LiveBeansView liveBeansView = new LiveBeansView();

    public BeansEndpoint() {
        super("/beans");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context.getEnvironment().getProperty("spring.liveBeansView.mbeanDomain") == null) {
            this.liveBeansView.setApplicationContext(context);
        }
    }

    @Override
    public MediaType[] getProduces() {
        return new MediaType[]{MediaType.APPLICATION_JSON};
    }

    @Override
    public String invoke() {
        return this.liveBeansView.getSnapshotAsJson();
    }
}

